$(document).ready( function(){
    $("select").select2();

    $("#slcArea").select2({
        placeholder: "Buscar Área",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'estructura_organizativa/procesos/get_areas_ajax',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (area) {
                return {
                    area: area
                }
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.are_id,
                        'text': item.are_nombre
                    });
                });

                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $('body').on('click', '.btn-eliminar', function(e){
        e.preventDefault();
        var url = $(this).attr('href');
        alerta_confirm_ajax(anularla, url, "Alerta confirmación", '¿Está seguro que desea anular esta Incapacidad?<br>Esta acción no se puede deshacer.');
    });

    // $("#btnConsultar").click(function(){
    //     var plan_operativo = $("#slcPlanOperativo").val();
    //     var area = $("#slcArea").val();
    //     var obj_op = $("#slc_obj_ope").val();

    //     if(plan_operativo==''){
    //         crear_alerta('error','Indicadores Operativos','Debe espeficiar un Plan Operativo');
    //         return false;
    //     }
    //     $("#dv_contenedor_documentos").hide('slide',{
    //         direction:'right'
    //     }, 400,function(){
    //         $.ajax({
    //             type:'post',
    //             dataType: 'json',
    //             url:window.location.pathname,
    //             data:{
    //                 plan_operativo: plan_operativo,
    //                 area: area,
    //                 obj_op: obj_op
    //             },
    //             beforeSend:function(){
    //                 wait.start();
    //             },
    //             success:function(result){
    //                 wait.close();
    //                 console.log(result);
    //                 var oTabla = $("#tblDocumentos").dataTable();
    //                 oTabla.fnDestroy();
    //                 $("#tbContenedorDocumentos").html(result.html);
    //                 $("#dv_contenedor_documentos").show("slide", {
    //                     direction: 'left'
    //                 }, 500);
    //                 aplicarDataTable('#tblDocumentos');
    //             }
    //         });
    //     });
    // });

});

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function anularla(url = "") {
    if (url != "") {
        window.open(url, '_self');
    }
}