$(document).ready(function () {
    $('select').select2({placeholder: 'Seleccione'});

    $("#slcArea").change(function(){
        cargar_data_plan();
    });

    $("#slcPlanOperativo").change(function(){
        cargar_data_plan();
        cargar_codigo_periodo();
    });

    $("#slcMes").change(function(){
        cargar_codigo_periodo();
    });

    $("#slcArea").select2({
        placeholder: "Buscar Área",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'estructura_organizativa/procesos/get_areas_ajax',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (area) {
                return {
                    area: area
                }
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.are_id,
                        'text': item.are_nombre
                    });
                });

                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#frm-registro").validate({
        ignore: '',
        rules: {
            slcTipoCuestionario: {required: true},
            txtNombre: {required: true},
            slcEstado: {required: true},
            slcTipoPrograma: {required: true}
        },
        // Specify the validation error messages
        messages: {
            "slcRol[]": 'Debe seleccionar al menos un rol'
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').html(error);
        },
        submitHandler: function (form) {
            form.submit();
        }
    });

    $("#btnAgregar").click(function () {
        var fila = $("#hdnFila").val();
        var meta = $("#slcMetas").val();
        var nombreMeta = $("#slcMetas option:selected").text();

        if (meta == "") {
            crear_alerta('error', 'Metas', 'Debe seleccionar una meta.');
            return false;
        }

        if ($("#tr_" + meta).length > 0) {
            crear_alerta('error', 'Metas', 'La Meta ya ha sido ingresada.');
            return false;
        }

        //Nuevo registro
        var numTr = meta;
        var html = '<tr id="tr_' + numTr + '" class="trSecciones">';
        html += '<td>' +
            '<input type="hidden" id="hdnFila_' + numTr + '" name="hdnSeccion[]" value="0">' +
            '<input type="hidden" id="hdnMeta_' + numTr + '" name="hdnMeta[]" value="' + meta + '">' +
            '<input type="text" readonly="readonly" id="txtNombre_' + numTr + '"  class="tables-input nombreSeccion" value="' + nombreMeta + '"/>' +
            '</td>';
        html += '<td>';
        html += '<button type="button" data-fila="' + numTr + '" class="btn btn-danger btn-mini btnDel icon16 icomoon-icon-remove" style="float:left; height:30px;width:30px;"></button>';
        html += '</td>';
        html += '</tr>';
        var oTabla = $("#tblSeccion").dataTable();
        oTabla.fnDestroy();
        $("#tbSeccion").append(html);
        aplicarDataTable('#tblSeccion');

        $("#txtSeccion").val('');
        $("#txtSeccion").focus();
        $("#txtDescripcionSec").val('');
    });

    $("#btnGuardarPrograma").click(function () {
        var fila = $("#hdnFila").val();
        var seccion = $("#txtSeccionModal").val();
        var descripcion_seccion = $("#txtDescripcionModal").val();

        if (seccion == "") {
            crear_alerta('error', 'Secciones', 'Debe ingresar el nombre de la sección');
            return false;
        }

        //Editar Fila
        $("#txtNombre_" + fila).val(seccion);
        $("#txtDescripcionSec_" + fila).val(descripcion_seccion);
        $.fancybox.close();
    });

    $('body').on('click', '.btnDel', function () {
        var table = $('#tblSeccion').DataTable();
        var parent = $(this).parent().parent();
        var nRow = $(parent).attr("id");
        table.fnDeleteRow(parent[0]);
    });
});

jQuery(document).ready(function ($) {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;

    $("#slc_sucursal").select2();

    $("#txtUsuario").blur(function () {
        $.ajax({
            dataType: 'json',
            type: 'POST',
            data: {usuario: $(this).val(), usuario_id: $("#hdnUsuario").val()},
            url: urlj + 'sistema/acceso/validar_nombre_usuario',
            success: function (data) {
                $("#usuario_error").css("margin-top", "-3%");
                if (data.respuesta == 1) {
                    $("#txtUsuario").addClass("existe");
                    $("#txtUsuario_error").html("Usuario ya existe");
                } else if (data.respuesta == 0) {
                    $("#txtUsuario").addClass("espacio");
                    $("#txtUsuario_error").html("Espacios en blanco NO permitidos");
                } else {
                    $("#txtUsuario").removeClass("existe espacio");
                    $("#txtUsuario_error").html('');
                }
            }
        })
    });
});


function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function limpiarModal() {
    $("#hdnFila").val(0);
    $("#txtSeccionModal").val('');
    $("#txtDescripcionModal").val('');
}

function cargar_codigo_periodo(){
    var plan_ope = $("#slcPlanOperativo").val();
    var mes = $("#slcMes").val();

    if(plan_ope!='' && mes!=''){
        var anio = $("#slcPlanOperativo option:selected").data('anio').toString();

        var codigo = (mes < 10) ? anio.concat('0', mes): anio.concat(mes);

        $("#hdnPeriodo").val(codigo);
    }
}

function cargar_data_plan(){

    var plan_ope = $("#slcPlanOperativo").val();
    var area = $("#slcArea").val();
    if(plan_ope!='' && area!=''){

        $.ajax({
            url: urlj + 'modulo_planificacion/pla_plan_operativo/get_datos_plan_operativo',
            type:'post',
            dataType:'json',
            data:{plan_operativo:plan_ope, area:area},
            success:function(data){
                if(data!=null){
                    $("#hdnPlanOperativo").val(data.id);
                    cargar_metas(data.id);
                }
            }
        });
    }
}

function cargar_metas(plan_ope){

    $.ajax({
        url: urlj + 'modulo_planificacion/pla_plan_operativo/get_metas_operativas',
        type:'post',
        dataType:'json',
        data:{plan_operativo:plan_ope},
        success:function(data){
            $("#slcMetas").html('');
            if(data!=null){
                //Se agregan las opciones a la meta
                var html  = '<option value=""></option>';
                $("#slcMetas").append(html);
                $.each(data, function(index, value){
                    html  = '<option value="'+value.id+'">'+value.nombre+ '</option>';

                    $("#slcMetas").append(html);
                });
                $("#slcMetas").select2({
                    placeholder:"Seleccione una opción"
                });
            }
        }
    });
}