$(document).ready(function () {
    $('select').select2({placeholder: 'Seleccione'});

    $("#slcArea").change(function(){
        cargar_data_plan();
    });

    $("#slcPlanOperativo").change(function(){
        cargar_data_plan();
    });

    $("#slcArea").select2({
        placeholder: "Buscar Área",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'estructura_organizativa/procesos/get_areas_ajax',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (area) {
                return {
                    area: area
                }
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.are_id,
                        'text': item.are_nombre
                    });
                });

                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#frm-registro").validate({
        ignore: '',
        rules: {
            slcTipoCuestionario: {required: true},
            txtNombre: {required: true},
            slcEstado: {required: true},
            slcTipoPrograma: {required: true}
        },
        // Specify the validation error messages
        messages: {
            "slcRol[]": 'Debe seleccionar al menos un rol'
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').html(error);
        },
        submitHandler: function (form) {
            form.submit();
        }
    });
});

jQuery(document).ready(function ($) {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;

    $("#slc_sucursal").select2();

    $("#txtUsuario").blur(function () {
        $.ajax({
            dataType: 'json',
            type: 'POST',
            data: {usuario: $(this).val(), usuario_id: $("#hdnUsuario").val()},
            url: urlj + 'sistema/acceso/validar_nombre_usuario',
            success: function (data) {
                $("#usuario_error").css("margin-top", "-3%");
                if (data.respuesta == 1) {
                    $("#txtUsuario").addClass("existe");
                    $("#txtUsuario_error").html("Usuario ya existe");
                } else if (data.respuesta == 0) {
                    $("#txtUsuario").addClass("espacio");
                    $("#txtUsuario_error").html("Espacios en blanco NO permitidos");
                } else {
                    $("#txtUsuario").removeClass("existe espacio");
                    $("#txtUsuario_error").html('');
                }
            }
        })
    });
});

function cargar_data_plan(){

    var plan_ope = $("#slcPlanOperativo").val();
    var area = $("#slcArea").val();
    if(plan_ope!='' && area!=''){

        $.ajax({
            url: urlj + 'modulo_planificacion/pla_plan_operativo/get_datos_plan_operativo',
            type:'post',
            dataType:'json',
            data:{plan_operativo:plan_ope, area:area},
            success:function(data){
                if(data!=null){
                    $("#hdnPlanOperativo").val(data.id);
                }
            }
        });
    }
}