var pesDate_ini = $("#start_pes_date").val();
var pesDate_fin = $("#final_pes_date").val();
$(document).ready(function(){
    $('select').select2({placeholder:"Seleccione una opción"});

    $(".txtFecha").datepicker('destroy');
    $(".txtFecha").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        minDate: new Date(pesDate_ini),
        maxDate: new Date(pesDate_fin),
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".txtFecha").mask("99-99-9999");

    $("#frm_contenedor").validate({
        ignore: [],
        rules: {
            txtAccionOperativa: {required: true},
            slcTipoPago: {required: true},
            slcTipoDocumento: {required: true},
            txtNumDoc: {required: true},
            txtFechaDoc: {required: true},
            txtFechaConta: {required: true},
            //txtFechaVencimiento: {required: true},
            slcTipo: {required: true},
            slcOrdenCompra : { required: false}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            $("#pes-generales").trigger('click');
        },
        submitHandler: function (form) {
            if ($("#txtFechaInicio").val() != "" && $("#txtFechaFin").val() != "") {
                if (!(verifica_fecha($("#txtFechaInicio").val(), $("#txtFechaFin").val()))) {
                    return false;
                } else {
                    form.submit();
                }
            } else {
                form.submit();
            }
            

            
        }
    });

    $(document).on("change", "#txtFechaInicio, #txtFechaFin", function () {
        if ($("#txtFechaInicio").val() != "" && $("#txtFechaFin").val() != "") {
            verifica_fecha($("#txtFechaInicio").val(), $("#txtFechaFin").val());
        }
    });

    $("#btnAgregarProgra").click(function(){
        var unidadesMeta = $("#txtUnidadesMet").val();
        var anioProg = $("#slcAnioPrograma").val();
        var unidadesProg = $("#txtUnidadesProg").val();
        var montoAsignacion = $("#txtMontoAsig").val();
        var fechaInicio = $("#txtFechaInicioProg").val();
        var fechaFin = $("#txtFechaFinProg").val();
        if(unidadesMeta == "" || unidadesMeta <= 0){
            crear_alerta('error','Programación', 'Debe asignar las unidades a programar.');
            return false;
        }
        if(anioProg == "" || unidadesProg == "" || montoAsignacion == "" || fechaInicio == "" || fechaFin == ""){
            crear_alerta('error','Programación', 'Los campos con asterisco son requeridos');
            return false;
        }
        if($("#tr_" +anioProg).length > 0){
            crear_alerta('error','Programación', 'El año ya fue ingresado.');
            return false;
        }
        if (parseFloat(unidadesProg) > parseFloat(unidadesMeta)) {
            crear_alerta('error','Programación', 'No debe superar las unidades a programar.');
            return false;
        }
        var porcentaje = (unidadesProg / unidadesMeta) * 100;
        var numTr = anioProg;
        var html = "<tr id='tr_"+anioProg+"'>";
        html += '<td>' +
            '<input type="hidden" id="hdnFila_'+numTr+'" name="hdnFila[]" value="0">' +
            '<input type="hidden" id="hdnAnio_'+numTr+'" name="hdnAnio[]" value="'+anioProg+'">' +
            '<input type="hidden" id="hdnPorcentaje_'+numTr+'" name="hdnPorcentaje[]" value="'+porcentaje+'">' +
            '<input type="hidden" id="hdnUnidades_'+numTr+'" name="hdnUnidades[]" value="'+unidadesProg+'">' +
            '<input type="hidden" id="hdnFechaDesde_'+numTr+'" name="hdnFechaDesde[]" value="'+fechaInicio+'">' +
            '<input type="hidden" id="hdnFechaHasta_'+numTr+'" name="hdnFechaHasta[]" value="'+fechaFin+'">' +
            '<input type="hidden" id="hdnMontoAsig_'+numTr+'" name="hdnMontoAsig[]" value="'+montoAsignacion+'">' +
            '<span id="lblAnio_'+numTr+'">'+anioProg+'</span>'+
            '</td>';
        html += '<td style="text-align: right;">' +
            '<span id="lblPorcentaje_'+numTr+'">'+porcentaje.toFixed(2)+'%</span>'+
            '</td>';
        html += '<td style="text-align: right;">' +
            '<span id="lblUnidades_'+numTr+'">'+ number_format(unidadesProg, 2)+'</span>'+
            '</td>';
        html += '<td style="text-align: right;">' +
            '<span id="lblAsignacion_'+numTr+'">' + number_format(montoAsignacion, 2) + '</span>'+
            '</td>';
        html += '<td>' +
            '<span id="lblFechaDesde_'+numTr+'">'+fechaInicio+'</span>'+
            '</td>';
        html += '<td>' +
            '<span id="lblFechaHasta_'+numTr+'">'+fechaFin+'</span>'+
            '</td>';
        html += '<td>'+
            '<button type="button" data-fila="'+numTr+'" class="btn btn-danger btn-mini btnDel icon16 icomoon-icon-remove" style="float:left; /*margin-left:5%;*/ height:30px;width:30px;"></button>';
        html += '</td>';
        html += "</tr>";

        var oTabla = $("#tblProgramacion").dataTable();
        oTabla.fnDestroy();
        $("#tbProgramacion").append(html);
        aplicarDataTable('#tblProgramacion');

        $("#slcAnioPrograma").val('').trigger('change');
        $("#txtUnidadesProg").val('');
        $("#txtMontoAsig").val('');
        $("#txtFechaInicioProg").val('');
        $("#txtFechaFinProg").val('');
    });

   $('body').on('click','.btnDel', function(){
      var table = $('#tblProgramacion').DataTable();
      var parent = $(this).parent().parent();
      table.fnDeleteRow( parent[0]);
   });
});

function aplicarDataTable(idTabla) {
   $(idTabla).dataTable({
      "sPaginationType": "full_numbers",
      "bJQueryUI": false,
      "bAutoWidth": false,
      "iDisplayLength": 20,
      "bLengthChange": false,
      "bDestroy": true,
      "fnInitComplete": function (oSettings, json) {
         $('.dataTables_filter>label>input').attr('id', 'search');
      }
   });
}

function verifica_fecha(fecha_ini, fecha_fin){
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error','Periodo Fechas','Verifique Fechas de Inicio y Fin del Período');
        return false;
    } else {
        return true;
    }
}