$(document).ready(function () {
    //window.gSateliteWhite.jsSelect();   
    $("select").select2({placeholder:"Seleccione una opción"});
    $(".datePicker").mask('99-99-9999');
    $(".datePicker").removeClass('hasDatepicker').datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        //minDate: 0
    });

    $("#slcArea").select2({
        placeholder: "Buscar Área",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'estructura_organizativa/procesos/get_areas_ajax',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (area) {
                return {
                    area: area
                }
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.are_id,
                        'text': item.are_nombre
                    });
                });

                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#btnConsultar").click(function () {

        var estado      = $("#slcEstado").val();
        var fecha_ini   = $("#txtFechaIni").val();
        var fecha_fin   = $("#txtFechaFin").val();
        var tipo        = $("#slcTipo").val();
        var slc_area= $("#slcArea").val();


        $("#dv_contenedor_tareas").hide('slide', {
            direction: 'right'
        },
        400, function () {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('modulo_planificacion/pla_inicio/tareas_pendientes/1'),
                data: {estado: estado, fecha_ini: fecha_ini, fecha_fin: fecha_fin,tipo:tipo,slc_area:slc_area},
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    var oTabla = $("#tblTareas").dataTable();

                    oTabla.fnDestroy();
                    $("#tbContenedorTareas").html(result);

                    $("#dv_contenedor_tareas").show("slide", {
                        direction: 'left'
                    }, 500);
                    aplidarDataTable('tblTareas');
                }
            });
        }
        );
    });

    $("#btnConsultar").click();

    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width:'100%',
            closeBtn: true
        });
    });

    $('#detalles').tooltip();
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        },
        "aaSorting": []
    });
}