$(document).ready(function () {
    $("select").select2({placeholder: "Seleccione un opción"});

    $(".txtDate").mask("99-99-9999");
    $(".txtDate").attr('placeholder', 'dd-mm-yy');
    $(".txtDate").removeClass('hasDatepicker').datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
    });btnHabilitarMasivo

    $("#LstTipo").change(function (){
        if($(this).val() == 1){
            $("#dvMesMasivo").hide();
        }
        else{
            $("#dvMesMasivo").show();
        }
    });

    $("#btnConsultar").click(function () {
        var plan_operativo = $("#slcPlanOperativo").val();

        if (plan_operativo == '') {
            $("#dvAdd").hide(500);
            crear_alerta('error', 'Habilitar Periodos', 'Debe espeficiar un Plan Operativo');
            return false;
        }

        $("#dv_contenedor_documentos").hide('slide', {
                direction: 'right'
            },
            400, function () {
                $.ajax({
                    type: 'post',
                    url: window.location.pathname,
                    data: {plan_operativo: plan_operativo},
                    dataType: 'json',
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (result) {
                        $("#dvAdd").show(500);
                        wait.close();
                        var oTabla = $("#tblDocumentos").dataTable();

                        oTabla.fnDestroy();
                        $("#tbContenedorDocumentos").html(result.html);

                        $("#dv_contenedor_documentos").show("slide", {
                            direction: 'left'
                        }, 500);
                        aplicarDataTable('#tblDocumentos');
                    }
                });
            }
        );
    });


    $(".addFormu").fancybox({
        parent: "form:first",
        width: '75%',
        height: '100%',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
            var id = $(this.element[0]).attr('data-id');

            $("[id$=LstUnidadFormu] option[value='" + id + "']").attr("selected", "selected");
            $("[id$=LstUnidadFormu]").select2();
            setTimeout(function () {
                $("[id$=CbEnvioFormulacion]").iButton({
                    'labelOn': 'Si',
                    'labelOff': 'No',
                    'width': '100%',
                    change: function (element) {
                        if (element.is(':checked')) {
                            $("[id$=hdfEnvioFormulacion]").val(1);
                        } else {
                            $("[id$=hdfEnvioFormulacion]").val(0);
                        }
                    }
                });
            }, 300);
        },
        beforeClose: function () {

            var listado = $(".listAnexos li");

            if (listado.length > 0) {
                listado.html('');
            }
        }
    });

    $(".addSegui").fancybox({
        parent: "form:first",
        width: '75%',
        height: '100%',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
            var id = $(this.element[0]).attr('data-id');

            $("[id$=LstUnidadSeg] option[value='" + id + "']").attr("selected", "selected");
            $("[id$=LstUnidadSeg]").select2();
            setTimeout(function () {
                $("[id$=CbEnvioSeguimiento]").iButton({
                    'labelOn': 'Si',
                    'labelOff': 'No',
                    'width': '100%',
                    change: function (element) {
                        if (element.is(':checked')) {
                            $("[id$=hdfEnvioSeguimiento]").val(1);
                        } else {
                            $("[id$=hdfEnvioSeguimiento]").val(0);
                        }
                    }
                });
            }, 300);

        },
        beforeClose: function () {

            var listado = $(".listAnexosSeg li");

            if (listado.length > 0) {
                listado.html('');
            }
        }
    });

    $(".addRepro").fancybox({
        parent: "form:first",
        width: '75%',
        height: '100%',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
            var id = $(this.element[0]).attr('data-id');

            $("[id$=LstUnidadRepro] option[value='" + id + "']").attr("selected", "selected");
            $("[id$=LstUnidadRepro]").select2();

            setTimeout(function () {
                $("[id$=CbEnvioRepro]").iButton({
                    'labelOn': 'Si',
                    'labelOff': 'No',
                    'width': '100%',
                    change: function (element) {
                        if (element.is(':checked')) {
                            $("[id$=hdfEnvioRepro]").val(1);
                        } else {
                            $("[id$=hdfEnvioRepro]").val(0);
                        }
                    }
                });
            }, 300);

        },
        beforeClose: function () {

            var listado = $(".listAnexosRepro li");

            if (listado.length > 0) {
                listado.html('');
            }
        }
    });

    $(".addMasiva").fancybox({
        width: '75%',
        height: '100%',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
            setTimeout(function () {
                $("[id$=CbEnvioMasivo]").iButton({
                    'labelOn': 'Si',
                    'labelOff': 'No',
                    'width': '100%',
                    change: function (element) {
                        if (element.is(':checked')) {
                            $("[id$=hdfEnvioMasivo]").val(1);
                        } else {
                            $("[id$=hdfEnvioMasivo]").val(0);
                        }
                    }
                });
            }, 300);
        },
        beforeClose: function () {
            var listado = $(".listAnexosMasiva li");

            if (listado.length > 0) {
                listado.html('');
            }
        }
    });

    /* Anexos */
    //Carpeta de Anexos
    var anx = 0;
    var folder_anx_temp = $('#carpeta_temporal').val();
    var ruta_anx = urlj + 'inicio/guardar_gral/' + folder_anx_temp;
    new FUload('btnAnexoMasivo', ruta_anx, {
        start: function (file) {
            wait.start();
        },
        sucess: function (data) {
            wait.close();

            if ($.trim(data) !== "") {
                var nombreArchivo = data;
                var a_exten = $.trim(data).split('.');

                var exten = "." + a_exten[(a_exten.length - 1)];
                var nombreSimple = $.trim(data).replace(exten, '');
                var rutaArchivo = ruta_anx + '/' + data;

                var html = "<span id='" + nombreSimple + "'>";
                html += "<li id='" + nombreSimple + "'>";

                html += "<a href='#' class='anexoPersonalizado dont-break-out' target='_blank' title='" + nombreArchivo + "'>";
                html += "<span class='icon iconic-icon-document-alt-fill'></span><span class='txt'></span>";
                html += nombreSimple + "</a>";
                html += "<input type='hidden' name='anexoArray[]' value='" + nombreArchivo + "' />";
                html += "<li id='" + nombreSimple + "'>";


            } else { //el formato es incorrecto
                crear_alerta('error', 'Formato Incorrecto', 'El archivo es inválido');
            }
        }
    });

    $(".eliminar_imagen").live("click", function (event) {
        event.preventDefault();

        url = this.custom;
        id_key = this.custom_id;
        id = this.id;
        $.ajax({
            type: 'POST',
            url: urlj + 'inicio/eliminar_imagen_gral/' + folder_anx_temp,
            data: {url: url},
            success: function (data) {
                $("#ruta" + id_key).val("");
                $("#" + id).parent().parent().remove().delay(300);
            }
        });
    });

    $(".delete_anexo").live('click', function (event) {
        event.preventDefault();

        var anexo = $(this).data('anexo');

        $("#anexo_" + anexo).remove().delay(500);
    });

    $(".verAnexo").fancybox({
        openEffect: 'elastic',
        closeEffect: 'elastic',
        href: $(this).attr('href'),
        type: 'iframe',
        helpers: {
            title: {
                type: 'inside'
            }
        }
    });

    /* Fin Anexos */


    $("#btnHabilitarMasivo").click(function(){

        var tipoHabilitacion = $("#LstTipo").val();
        var mes = $("#LstMesMasiva").val();
        var fechaInicio = $("#TxtDesdeMasiva").val();
        var fechaFin = $("#TxtHastaMasiva").val();
        var comentario  = $("#TxtObserMasiva").val();
        var planOperativo = $("#slcPlanOperativo").val();

        if(tipoHabilitacion == "" || fechaFin == "" || fechaInicio == ""){
            crear_alerta('error','Habilitación Masiva','Debe Completar los campos requeridos');
            return false;
        }

        if(planOperativo == ''){
            crear_alerta('error','Habilitación Masiva','Debe seleccionar un plan operativo');
            return false;
        }

        $.ajax({
            url: urlj + 'modulo_planificacion/pla_configuracion/habilitaciones',
            type:'post',
            data: { tipoHabilitacion: tipoHabilitacion, mes: mes, fechaInicio: fechaInicio, fechaFin: fechaFin, comentario:comentario,
                planOperativo:planOperativo, masivo:1},
            dataType:'json',
            beforeSend: function(){
                wait.start();
            },
            success:function(response){
                wait.close();
                crear_alerta('success','Habilitación Masiva','Se habilitaron las tareas');
            }
        });
    });
});

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
