$(document).ready(function() {
    $("select").select2({placeholder: 'Seleccionar...'});
    $(".datePicker").attr('placeholder', "dd-mm-yyyy");
    $(".datePicker").datepicker({
        dateFormat: 'dd-mm-yy',
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });


    $('#slcpaciente').change(function(event) {
        var slcpaciente = $(this).val(); 
        $("#slcconsulta").select2("val", "");
        $("#slcaseguradora").select2("val", "");
        $("#slcformulario").select2("val", "");
        if(slcpaciente != ''){
            $.ajax({
                type:'post',
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('modulo_medico/med_reportes/aseguradoras_pacientes'),
                data:{
                    paciente: slcpaciente
                },
                beforeSend:function(){
                    wait.start(); 
                },
                success:function(result){
                    // console.log(result);
                    $("#slcaseguradora").html(result);
                    $("#slcformulario").html('<option value=""></option>');
                    wait.close();
                }
            });
        } else{
            $("#slcconsulta").html('<option value=""></option>');
            $("#slcaseguradora").html('<option value=""></option>');
            $("#slcformulario").html('<option value=""></option>');
        }
    });

    $('#slcconsulta').change(function(event) {
        $("#slcaseguradora").select2("val", "");
        $("#slcformulario").select2("val", "");
        var slcpaciente = $('#slcpaciente').val();
        var slcconsulta = $(this).find('option:selected').text();        
        if(slcpaciente != '' && slcconsulta != ''){
            $.ajax({
                type:'post',
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('modulo_medico/med_reportes/aseguradoras_pacientes'),
                data:{
                    paciente: slcpaciente,
                    slcconsulta: slcconsulta
                },
                beforeSend:function(){
                    wait.start(); 
                },
                success:function(result){
                    // console.log(result);
                    $("#slcaseguradora").html(result);
                    $("#slcformulario").html('<option value=""></option>');
                    wait.close();
                }
            });
        } else{
            $("#slcaseguradora").html('<option value=""></option>');
            $("#slcformulario").html('<option value=""></option>');
            
        }
    });

    $('#slcaseguradora').change(function(event) {
        var slcaseguradora = $('#slcaseguradora').val();
        if(slcaseguradora != ''){
            $.ajax({
                type:'post',
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('modulo_medico/med_reportes/formulario_select'),
                data:{
                    aseguradora: slcaseguradora,
                },
                beforeSend:function(){
                    wait.start(); 
                },
                success:function(result){
                    // console.log(result);
                    $("#slcformulario").html(result);
                    wait.close();
                }
            });
        } else{
            $("#slcformulario").html('<option value=""></option>');
            $("#slcformulario").select();
        }
    });

    $("#btnGenerar").click(function(){
        var formulario = $("#slcformulario").val();
        if(formulario == ""){
            crear_alerta('error','Formulario de aseguradora','Por favor seleccione un formulario.');
        }

        var base = $("#lnkFormulario").data('base');
        var urlFormulario = $("#slcformulario option:selected").data('url');

        $("#lnkFormulario").prop('href',base + urlFormulario);
        $("#lnkFormulario")[0].click();
    });
    
});