$(document).ready(function() {
    let idSucursal = $('#id_sucursal').val();
    consultarTurnosPacientes(idSucursal);

});

async function consultarTurnosPacientes(idSucursal) {
    try {
        let urlTurnoPacientes = window.gSateliteWhite.baseUrl(`modulo_medico/med_procesos/consulta_turno_paciente/${idSucursal}`);
        let response = await requestAjax(urlTurnoPacientes, 'GET');
        
        const pacientes = response.pacientes;
        let gridPlantilla = ''; // Inicializar la variable para acumular el HTML
        
        if (pacientes.length > 0) {
            pacientes.forEach(paciente => {
                gridPlantilla += `
                    <tr ${(paciente.clp_estado_consulta != 2) ? 'class="pendiente"' : '' }>
                        <td class="p-4" style="line-height: 1;"">${paciente.nombre_paciente}</td>
                        <td class="p-4" style="line-height: 1;">${paciente.con_nombre}</td>
                    </tr>
                `;
            });

            $('#tbody-content').html(gridPlantilla);
        } else {
            // Si no hay pacientes, mostrar un mensaje alternativo
            gridPlantilla = `
                <tr>
                    <td colspan="2" class="text-center p-4">No hay información para mostrar</td>
                </tr>
            `;
            $('#tbody-content').html(gridPlantilla);
        }  

        // Llamar a consultarTurnosPacientes nuevamente después de 5 segundos
        setTimeout(async () => {
            await consultarTurnosPacientes(idSucursal);
        }, 5000);

    } catch (error) {
        setTimeout(async () => {
            await consultarTurnosPacientes(idSucursal);
        }, 5000);
                
        console.error('Error al consultar los turnos de pacientes:', error);
        // crear_alerta('error', 'Error', 'Ocurrió un error al consultar los datos');
    }
}

const requestAjax = async function(url, method, data) {
    let response;
    try {
        response = await $.ajax({
            type: method,
            url: url,
            dataType: 'json',
            data: data,
        });
    } catch (error) {
        console.log(error);
        crear_alerta('error', 'Error', 'Ocurrió un error al consultar los datos');
    }
    return response;
}
