$(document).ready(function() {
    $("select").select2({placeholder: 'Seleccione'});

    $(".datePicker").datepicker({
        dateFormat: 'dd-mm-yy',
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").attr('placeholder', "dd-mm-yyyy");
    $(".datePicker").mask('99-99-9999');

    $("#btnConsultar").click(function (event){     
        var procedimiento   = $("#txt_procedimiento").val(); 
        var desde           = $("#txt_desde").val(); 
        var hasta           = $("#txt_hasta").val(); 
        var slc_paciente    = $("#slc_paciente").val(); 
        var estado          = $("#slcestado").val(); 

        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlj+'modulo_medico/med_procesos/procedimiento_quirurgico',
            data: { 
                procedimiento:procedimiento,
                desde: desde,                 
                hasta:hasta,
                slc_paciente:slc_paciente,
                estado:estado
            },
            success: function (data) {
                $("#contenedor_consulta").html(data.html);
                aplicar_datatable('#tbl_contenedor');
                $("#contenedor_consulta").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            },
            error: function (xhr, status, error) {
                wait.close();
                crear_alerta('error', 'Error', 'Se interrumpio debido a un problema al realizar la operación');
            }
        });
    });

    $("body").on("click", ".fancybox_modal",function() {
        event.preventDefault();
            var url = $(this).attr('href');
            $.fancybox({
                'href': url,
                type: 'iframe',
                width:'100%',
                closeBtn: true,
                height: '100%'
            });

    });

    $(".confirmar_programacion").on("click", function() {
        event.preventDefault();
            var url = $(this).attr('href');
            $.fancybox({
                'href': url,
                type: 'iframe',
                width:'100%',
                closeBtn: true,
                height: '100%'
            });

        });


    $("#slc_paciente").select2({
            placeholder: "Buscar Paciente...",
            minimumInputLength: 3,
            ajax: {
                url: urlj + 'modulo_medico/med_procesos/get_pacientes_like',
                dataType: 'json',
                type: 'POST',
                delay: 250,
                data: function (categoria) {
                   return {
                        categoria: categoria
                    };
                },
                results: function (data) {
                    var myResults = [];
                    $.each(data, function (index, item) {
                        myResults.push({
                            'id': item.epp_id,
                            'text': item.epp_numero_expediente + ' - ' + item.epp_nombre + ' ' + item.epp_apellido + ' ' + item.epp_apellido_casada
                        });
                    });
                    setTimeout(function() {

                    },200)
                    return {
                        results: myResults
                    };

                },
            
            }
        });

    
});

function aplicar_datatable(id){
    $(id).dataTable({
        "bFilter": true,
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 5,        
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}