$(document).ready(function() {
    $('#slcUbicacion, #slcEstado').select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});

    $("#txtFecha_desde,#txtFecha_hasta").change(function(event) {  validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta'); });

    consultarPacientes();
    
    $('#btnConsultar').on('click', function(e){
        e.preventDefault();
        let slcUbicacion = $('#slcUbicacion').val();
        let slcEstado = 1;
        let txtFecha_desde = $('#txtFecha_desde').val();
        let txtFecha_hasta = $('#txtFecha_hasta').val();
        let idConsultorio = $('#idConsultorio').val();
        const filtros = {
            slcUbicacion, slcEstado, txtFecha_desde, txtFecha_hasta
        };
        let url_ajax = window.satelite.base_url('modulo_medico/med_procesos/grid_clasificacion_paciente/' + idConsultorio);
        $.ajax({
            url: url_ajax,
            type: 'POST',
            // dataType: 'json',
            data: filtros,
            beforeSend: function() {
                wait.start();
            },
            error: function(xhr, status, error) {
            console.log('error');
                wait.close();
            },
            success: function(result) {
                $("#table-container").html($.trim(result));

                $('.grocery_table').dataTable({
                    "aaSorting": [[0, "asc"], [1, "desc"], [6, "asc"], [7, "asc"]],                  
                    "aoColumnDefs": [{ "bVisible": false, "aTargets": [0, 1] }],             
                });              
                wait.close();
            }
        });        
    });

    $('body').on('click', '.seleccionarPaciente', async function(e){
        e.preventDefault();
        let idConsultorio = $('#idConsultorio').val();
        let idClasificacionPaciente = $(this).data('id');
        let nombrePaciente = $(this).data('nombre-paciente');
        let url = $(this).attr('href');        

        sessionStorage.setItem('idPaciente', idClasificacionPaciente);
        let urlAsignarPacienteConsultorio = window.satelite.base_url('modulo_medico/med_procesos/clasificacionPacientexConsultorio');
        let urlInhabilitarPacienteConsultorio = window.satelite.base_url('modulo_medico/med_procesos/inhabilitarClasificacionPacientexConsultorio');
        let urlPacienteEnConsulta = window.satelite.base_url('modulo_medico/med_procesos/cambiarEstadoConsulta');

        // Al seleccionar usuario agregara al paciente al consultorio (turno)
        let response = await requestAjax(urlAsignarPacienteConsultorio, 'POST', {idConsultorio, idClasificacionPaciente});
        if (response.asignado == 1){
            crear_alerta('error', 'Paciente', 'El paciente ya ha sido asignado a un consultorio');
            consultarPacientes();
            return;
        }
        
        let flagContinuar = await confirmacionPaciente(nombrePaciente, idClasificacionPaciente);
        if (!flagContinuar){
            // Si el usuario no confirma la consulta se inhabilitara el paciente del consultorio (turno)
            await requestAjax(urlInhabilitarPacienteConsultorio, 'POST', {idConsultorio, idClasificacionPaciente});
            return false;
        }

        // Si el usuario confirma la consulta se cambiara el estado de clasificacion de paciente de "pendiente = 1" a "en consulta = 2" 
        let {cim_id} = await requestAjax(urlPacienteEnConsulta, 'POST', {idClasificacionPaciente});
        window.location = url + `/${cim_id}`;
    })  

    $('body').on('click', '.inhabilitarSeleccionPaciente', async function(e){
        e.preventDefault();
        let idConsultorio = $('#idConsultorio').val();
        let idClasificacionPaciente = $(this).data('id');
        let url_ajax = window.satelite.base_url('modulo_medico/med_procesos/inhabilitarClasificacionPacientexConsultorio');
        let nombrePaciente = $(this).data('nombre-paciente');
        let url = $(this).attr('href');

        // Guardar clasificacion paciente por consultorio
        let response = await requestAjax(url_ajax, 'POST', {idConsultorio, idClasificacionPaciente});
        if (response.exito == 1){
            crear_alerta('success', 'Paciente', 'Registro actualizado correctamente.');
            consultarPacientes();
            return;
        }
    }) 


    // $('body').on('click', '.seleccionarPaciente', function(e) {
    //     console.log('asdfasdf')
    //     e.preventDefault();
    //     $.fancybox({
    //         modal: false,
    //         width: '50%',
    //         height: '300',
    //         autoSize: false,
    //         closeClick: false,
    //         type: 'inline',
    //         href: '#modal_llamar_paciente',
    //         afterLoad: function() {
    //         },
    //         beforeClose: function() {
    //             $('#clp_id').val(null); 
    //             $('#txt_paciente').text(''); 
    //         }
    //     });               
    // });

});

const alerta_confirmacion = async function(title = 'Alerta confirmación', message = '¿Desea continuar?'){
    let respuesta = Swal.fire({
        title: title,
        text: message,
        icon: "question",
        showCancelButton: true,
        confirmButtonColor: "#203A6F",
        cancelButtonColor: "#ff3d60",
        confirmButtonText: "SI",
        cancelButtonText: "No"
        })
        .then(function (result) {
            if (!result.value) {
                return false;
            }else{
                return true;
            }
        });
    return respuesta;
}

const requestAjax = async function(url, method, data)
{
  let response;
  try{
      response = await $.ajax({
        type: method,
        url: url,
        dataType: 'json',
        data : data,
       })
  } catch (error){
    console.log(error);
    crear_alerta('error', 'Error', 'Ocurrió un error al consultar los datos');
  }
  return response;
}

const consultarPacientes = function () {
    setTimeout(()=> {
        $('#btnConsultar').trigger('click');
    }, 500);   
}

const confirmacionPaciente = function (nombrePaciente, idClasificacionPaciente) {
    return new Promise((resolve) => {
        $('#clp_id').val(idClasificacionPaciente); 
        $('#txt_paciente').text(nombrePaciente); 
        $.fancybox.open({
            href: '#modal_llamar_paciente',
            type: 'inline',
            modal: true,
            width: '50%',
            height: '300',
            autoSize: false,
            closeClick: false,
            clickSlide: false,   // desactiva cierre al hacer clic en el fondo
            clickOutside: false, // desactiva cierre al hacer clic fuera
            keyboard: false,     // desactiva cierre con Esc
            touch: false,        // (opcional) desactiva swipe en móviles                
            afterShow: function () {
                // Limpiar eventos antiguos y asignar nuevos
                $('#confirmarLlamado').off('click').on('click', function () {
                    $.fancybox.close();
                    resolve(true); // Usuario aceptó
                });

                $('#cancelarLlamado').off('click').on('click', function () {
                    $.fancybox.close();
                    resolve(false); // Usuario canceló
                });
            },
            beforeClose: function () {
                $('#clp_id').val(null); 
                $('#txt_paciente').text(''); 
            }
        });
    });
}