$(document).ready(function() {
    $('.select2').select2();

    $("#slcFilPaciente").select2({
        placeholder: "Buscar Paciente...",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_medico/med_procesos/get_pacientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
               return {
                    categoria: categoria
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    let documento = item.dop_valor;
                    let tipoDocumento = item.tde_nombre;
                    let textDocumento = (documento && documento != "") ? `(${tipoDocumento}: ${documento})` : "";
                    myResults.push({
                        'id': item.epp_id,
                        'text': `${item.epp_numero_expediente} - ${item.epp_nombre} ${item.epp_apellido} ${item.epp_apellido_casada} ${textDocumento}` 
                    });
                });
                setTimeout(function() {

                },200)
                return {
                    results: myResults
                };

            },
        initSelection: function (element, callback) {
                var idElemento = element[0].id;
                var valor = $("#" + idElemento).val();
                if (valor !== "") {
                    var texto = $("#" + idElemento).data('nombre');
                    callback({id: valor, text: texto});
                }
            }
        }
    });	

    $('#slcFilPaciente').next('.select2-container').removeClass('form-control');    

    $('#formRegistro').validate({
        ignore: null,
        rules: {
            slcFilPaciente:{ required: true},   
            slcUbicacion:{ required: true},   
            slcClasificacionEmergencia:{ required: true},   
            slcTipoConsulta:{ required: true},   
            // slcMotivoEmergencia:{ required: true},   
            // txtDetalleMotivoEmergencia:{ required: true},   
        } ,
        errorPlacement: function (error, element) {
            if($(element).is("select, input[type='hidden']")){ $(element).next().append(error); }
            else { 
                error.insertAfter(element);
            }
        },
        submitHandler: function(form){
            wait.start();
            form.submit();
        }
    });        

});