$(document).ready(function() {

    $("select").select2({placeholder: 'Seleccionar...'});
    $(".datePicker").attr('placeholder', "dd-mm-yyyy");
    $(".datePicker").datepicker({
        dateFormat: 'dd-mm-yy',
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $(".timepicker").timepicker({timeFormat: 'H:mm:ss'});
    $(".timepicker").mask('99:99:99');
    $(".timepicker").attr('placeholder', 'ejemplo: 08:00:00');

    $('.horas').timeEntry({
        show24Hours: false,
        showSeconds: false,
        spinnerIncDecOnly: true,
        spinnerImage: ' ',
        ampmPrefix: ' '
    });

    $("#agregar_expediente").on("click", function() {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width:'100%',
            closeBtn: true,
            height: '100%'
        }); 
    });

    $(".tooltip_pdf").on("click", function() {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            closeBtn: true,
            height: '100%'
        }); 
    });

             /*$(".delete_anexo").click(function(event){
                event.preventDefault();

                var anexo = $(this).data('anexo');
                var emp = $(this).data('emp');

                var data = {'anexo':anexo,emp:emp};

                alerta_confirm_ajax(eliminar_anexo_ticket,data,'Alerta de confirmación','¿Seguro que quieres eliminar permanentemente este anexo?');
            });*/

    $(".delete_anexo").live("click", function (event) {
        event.preventDefault();
        url = $(this).data('anexo');
        id = $(this).data('acd');

        //id = this.id;
        //console.log(url);
        $.ajax({
            type: 'POST',
            url: urlj + 'modulo_medico/med_procesos/eliminar_anexo_medico',
            data: {url: url,
                    id : id},
            success: function (data) {
                //$("#ruta" + id_key).val("");
                console.log('funciono: '+data.afectadas);
                $(this).closest('li').remove();
            }
        });
    });

    $("#slcpaciente").select2({
        placeholder: "Buscar Paciente...",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_medico/med_procesos/get_pacientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
                return {
                    categoria: categoria
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.epp_id,
                        'text': item.epp_numero_expediente+' - '+item.epp_nombre+' '+item.epp_apellido+' '+item.epp_apellido_casada+' '
                    });
                });
                setTimeout(function() {

                },200)
                return {
                    results: myResults
                };

            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#form_add").validate({
        ignore: "",
        rules: {
            slcpaciente: {required: true},
            slctipoconsulta: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').html(error);
        },
        submitHandler: function (form) {
            event.preventDefault(); 
            wait.start();
            var fecha = $("#txtfconsulta").val();
            var fecha_split = fecha.split("-");
            var hora_desde = $("#txthdesde").val();
            var hora_hasta = $("#txthhasta").val();
            var medico = $("#slcmedico").val();
            var lugar = $("#slclugar").val();
            var paciente = $("#slcpaciente").val();
            var tipo_consulta = $("#slctipoconsulta").val();
            var success = 0;
            var date = new Date();
            var idcim = $("#this_cita").val();
            var hora_inicio = new Date(fecha_split[1]+'/'+fecha_split[0]+'/'+fecha_split[2]+' '+hora_desde).getTime();
            var hora_fin =  new Date(fecha_split[1]+'/'+fecha_split[0]+'/'+fecha_split[2]+' '+hora_hasta).getTime();
            /* console.log('hora inicio: '+hora_inicio);
            console.log('hora fin:    '+hora_fin);*/
            if (hora_fin < hora_inicio) {
                crear_alerta('error','Horas Incorrecto', 'Las hora hora hasta no puede ser mayor que la hora desde');
                $("#txthdesde").val('');
                $("#txthhasta").val('');
                wait.close();
                return false;
            }
            $.ajax({
                url: urlj + 'modulo_medico/med_procesos/verificacion_horas/' + idcim,
                type: 'POST',
                dataType: 'json',
                async: false,
                data: {
                    lugar: lugar,
                    fecha : fecha,
                    medico : medico,
                    paciente: paciente,
                    hora_desde : hora_desde,
                    hora_hasta : hora_hasta,
                    tipo_consulta: tipo_consulta
                },
                success:function(data){
                    success = data.cim_id;
                }
            });
            if (success > 0) {
                crear_alerta('error', "Horario no disponible", "Las horas elegidas no estan disponibles.<br>Por favor verifique");
                wait.close();
                return false;
            }
            form.submit();
        }
    });

    $('#slcmedico, #txtfconsulta, #slctipoconsulta').on("change", function(){
        verificar_horario();
    });

    $("#txthdesde, #txthhasta").blur(function(){
        verificar_horario();
    });

        
});

function verificar_horario() {
    var idcim = $("#this_cita").val();
    var medico = $("#slcmedico").val();
    var medicoActual = $("#slcmedicoActual").val();
    var tipo_consulta = $("#slctipoconsulta").val();
    var tipo_consultaActual = $("#tipoconsultaActual").val();

    var fecha = $("#txtfconsulta").val();
    var fechaActual = $("#txtfConsultaActual").val();

    var hora_desde = $("#txthdesde").val();
    var hora_desdeActual = $("#txthdesdeActual").val();

    var hora_hasta = $("#txthhasta").val();
    var hora_hastaActual = $("#txthhastaActual").val();

    var fecha_split = fecha.split("-");
    var hora_desde_1 = new Date(fecha_split[1]+'/'+fecha_split[0]+'/'+fecha_split[2]+' '+hora_desde).getTime();
    var hora_desde_a = new Date(fecha_split[1]+'/'+fecha_split[0]+'/'+fecha_split[2]+' '+hora_desdeActual).getTime();
    var hora_hasta_1 = new Date(fecha_split[1]+'/'+fecha_split[0]+'/'+fecha_split[2]+' '+hora_hasta).getTime();
    var hora_hasta_a = new Date(fecha_split[1]+'/'+fecha_split[0]+'/'+fecha_split[2]+' '+hora_hastaActual).getTime();
    var hora_dsd_act_0 = hora_desde_a - 1000;//SE GUARDA AUMENTADO 1 SEGUNDO PARA EVITAR TRASLAPES POR LO QUE LE RESTAMOS 1 SEGUNDO

    if(hora_desde_1 != hora_dsd_act_0 || hora_hasta_1 != hora_hasta_a || fecha != fechaActual || medico != medicoActual || tipo_consulta != tipo_consultaActual){
        $.ajax({
            url: urlj + 'modulo_medico/med_procesos/verificacion_horas/' + idcim,
            type: 'POST',
            dataType: 'json',
            async: false,
            data: {
                fecha: fecha,
                medico: medico,
                hora_desde : hora_desde,
                hora_hasta : hora_hasta,
                tipo_consulta: tipo_consulta
            },
            beforeSend: function(){
                wait.start();
            },
            success:function(data){
                if(data.cim_id!=0){
                    crear_alerta('error', "Horario no disponible", "Las horas elegidas no estan disponibles.<br>No se puede cambiar el horario");
                    $("#txthdesde").val($('#txthdesdeActualFrm').val());
                    $("#txthhasta").val($('#txthhastaActualFrm').val());
                    $("#txtfconsulta").val($('#txtfConsultaActual').val());
                    $("#slcmedico").select2("val", medicoActual);
                    $("#slctipoconsulta").select2("val", tipo_consultaActual);
                }   
                wait.close();       
            }
        });
    }
}