$(document).ready(function() {

    $("select").select2({placeholder: 'Seleccionar...'});
    $(".datePicker").attr('placeholder', "dd-mm-yyyy");
    $(".datePicker").datepicker({
        dateFormat: 'dd-mm-yy',
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999')


    $("body").on("click", ".fancybox_modal",function() {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width:'100%',
            closeBtn: true,
            height: '100%'
        });
    });

    $(".confirmar_cita").on("click", function() {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width:'100%',
            closeBtn: true,
            height: '100%'
        });
    });

    $("body").on("click", "#btnConsultar", function(event){
        event.preventDefault();
        $("#citas_table").hide("slide", {direction: 'left'}, 400);
        //Se obtienen los detalles del Cliente
        $.ajax({
            dataType: 'json',
            type: 'post',
            data: $("#frmcumsultaform").serialize(),
            url: urlj + 'modulo_medico/med_procesos/consulta_medica',
            async: false,
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                var oTabla = $("#tbl_contenedor").dataTable();
                oTabla.fnDestroy();
                $("#tbContenedor").html(data);
                aplidarDataTable('tbl_contenedor');
                $("#citas_table").show("slide", {direction: 'right'}, 500);
                wait.close();
            }
        });
    });

    $("body").on("click", ".finalizar", function(){
        event.preventDefault(); 
        var url = $(this).attr("href");
            //var cnm_id = $(this).data("cnm_id");
        var data = { "url" : url};
        console.log(data);
        alerta_confirm_ajax(finalizar_consulta, data,'Alerta de Consulta Médica','¿Seguro desea finalizar la consulta, una vez finalizada no podrá editarla?');
    });

    $("#slcpaciente").select2({
        placeholder: "Buscar Paciente...",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_medico/med_procesos/get_pacientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
                return {
                    categoria: categoria
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.epp_id,
                        'text': item.epp_numero_expediente+' - '+item.epp_nombre
                        +' '+item.epp_apellido+' '+item.epp_apellido_casada
                    });
                });
                setTimeout(function() {

                },200)
                return {
                    results: myResults
                };
            },

        }
    });

    if ($("#txtfdesde"). val() != "") {
        $("#btnConsultar").trigger("click");
    }

});

function finalizar_consulta(data){

    wait.start();
    $.ajax({
        url: data.url,
        type: 'POST',
        dataType: 'text',
        async: false,
        success:function(data){
                console.log(data);
                if (data > 0) {
                    parent.location.reload();
                    return  false;
                }
                crear_alerta('error','Error', 'Fallo finalizar consulta, vuelva a intentarlo de nuevo');    
            }
        });

    }


function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}