$(document).ready(function() {

    $(".estado_cita").on("click", function(event) {    
        event.preventDefault();
        var estado = $(this).attr('id'); 
        if (estado == 'confirmar') {
            $("#confirmacion").val('2');
        } else {
            $("#confirmacion").val('0');
        }      
        form_submit();
    });

    $("#form_add").validate({
        ignore: "",
        rules: {          
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').text('Campo requerido');           
        },
        submitHandler: function (form) {
            wait.start();          
            form.submit();
        }
    });

    $("select").select2({placeholder: 'Seleccione'});
    $(".datePicker").attr('placeholder', "dd-mm-yyyy");
    $(".datePicker").datepicker({
        dateFormat: 'dd-mm-yy',
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $(".timepicker").timepicker({timeFormat: 'H:mm:ss'});
    $(".timepicker").mask('99:99:99');
    $(".timepicker").attr('placeholder', 'ejemplo: 08:00:00');

    $("#slc_tipo_procedimiento").on('change', function(){
        if (  $(this).val() != "") {
            var duracion = $(this).find(':selected').data('duracion')
            $("#txt_horas").val(duracion);        
        } else {
            $("#txt_horas").val("");
        }        
    });

    $("#agregar_expediente").on("click", function() {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width:'100%',
            closeBtn: true,
            height: '100%'
        }); 
    });

    $("#slc_paciente").on('change',function() {
        var id = $(this).val();
        get_medico(id);
    });

    $("#slc_paciente").select2({
        placeholder: "Buscar Paciente...",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_medico/med_procesos/get_pacientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
               return {
                    categoria: categoria
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.epp_id,
                        'text': item.epp_numero_expediente+' - '+item.epp_nombre                        
                    });
                });
                setTimeout(function() {

                },200)
                return {
                    results: myResults
                };

            }
        },
        initSelection: function (element, callback) {
                var idElemento = element[0].id;
                var valor = $("#" + idElemento).val();
                if (valor !== "") {
                    var texto = $("#" + idElemento).data('nombre');
                    callback({id: valor, text: texto});
                }
            }
    });

    function form_submit(){      
        wait.start();
        $.ajax({
            url: urlj + 'modulo_medico/med_procesos/confirmar_programacion/',
            type: 'POST',
            dataType: 'json',
            async: false,
            data: $("#form_add").serialize(),
            success:function(data){               
                if (data.procedimiento > 0) {                    
                    parent.$.fancybox.close();
                    parent.location.reload();
                } else {
                    crear_alerta('error','Error', 'No se a cancelado ó confirmado el procedimiento quirúrgico');
                }
                wait.close();    
            }
        });

    }

    $("#slc_tipo_procedimiento").trigger("change");    
    $('#slc_paciente').select2("disable");
});

function get_medico(){
    var confirmacion        = $("#confirmacion").val();
    var txt_procedimiento   = $("#txt_procedimiento").val();

    $.ajax({
        url: urlj + 'modulo_medico/med_procesos/get_medico',
        type: 'POST',
        dataType: 'json',
        data: { confirmacion : confirmacion,txt_procedimiento:txt_procedimiento },
        success:function(data){
            if (data.epp_id_med != null) {
                $('#slcmedico').select2('destroy');
                $('#slcmedico').val(data.epp_id_med);
                $('#slcmedico').select2();
                $('#slcmedico').select2({placeholder: 'Seleccione'});
            }
        }
    });
}