$(document).ready(function() {
    $("select").select2({placeholder: 'Seleccionar...'});
    $(".datePicker").attr('placeholder', "dd-mm-yyyy");
    $(".datePicker").datepicker({
        dateFormat: 'dd-mm-yy',
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".timepicker").timepicker({timeFormat: 'H:mm:ss'});
    $(".timepicker").mask('99:99:99');
    $(".timepicker").attr('placeholder', 'ejemplo: 08:00:00');

    $(".estado_cita").on("click", function() {
        event.preventDefault();
        var estado = $(this).attr('id'); 
        if (estado == 'confirmar') {
            $("#confirmar_cita").val('2');
        } else {
            $("#confirmar_cita").val('0');
        }

        $('#btnCrear').click();
    });

    $("#slcpaciente").select2({
        placeholder: "Buscar Paciente...",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_medico/med_procesos/get_pacientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
                 //var anticipo = ($('#anticipo').is(':checked'))?1:0;
               return {
                    categoria: categoria
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.epp_id,
                        'text': item.epp_numero_expediente + ' - ' + item.epp_nombre + ' ' + item.epp_apellido+ ' ' + item.epp_apellido_casada
                    });
                });
                setTimeout(function() {

                },200)
                return {
                    results: myResults
                };

            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
        
    });

    var ruta = urlj + 'inicio/guardar_gral/anexos_medicos';
    new FUload('btn_foto_inventario', ruta, {
        start: function (file) {
            wait.start();
        }, sucess: function (data) {
            wait.close();
            if ($.trim(data) != "") {
                //obtener la extención
                a_exten = $.trim(data).split('.');
                exten = a_exten[(a_exten.length - 1)].toLowerCase();
                // console.log(exten);
                if (exten == 'jpg' || exten == 'jpeg' || exten == 'png' || exten == 'pdf') {
                    $("#previews_foto").empty();
                    if (exten == 'pdf') { src = urlj + 'media/imagenes/sistema/' + exten + '.png'; } else { src = urlj + 'public/temp/anexos_medicos/' + $.trim(data); }
                    var preview = "<tr id='previewruta_foto_empleado' style='display:none;' class='preview_documento'>";
                    preview += '<td><a  title="Ver Anexo" class="verAnexo" href="' + urlj + 'public/temp/anexos_medicos/' + $.trim(data) + '">';
                    preview += '<img id="img_pre" src="' + src + '" width="88" height="88" class="imagen_documento"></a></td>';
                    preview += '<td><input maxlength="75" style="width:50%;" class="titulo_documento" type="text" name="titulo_foto_empleado" id="titulo_foto_empleado" value="' + a_exten[0] + '"><span style="display:none;font-size:11px;color:red;margin-top:-10%" class="texto" id="titulo_foto_empleado"></span><br><small style="text-align:left;">Nombre del documento</small></td>';
                    preview += '<td style="vertical-align:middle !important; width:30px !important;"><img style="display:none;" src="' + urlj + 'media/editar_documento.png" title="Editar" value="titulo_foto_empleado" class="editar_documento"/></td>';
                    preview += '<td style="background:#E1E7F0!important;"><a href="javascript: void(0);" title="Eliminar Anexo" class="eliminar_imagen" id="delete" custom="' + $.trim(data) + '" custom_id=""><img class="quitar_documento" src="' + urlj + 'media/eliminar_documento.png" title="Eliminar documento"></a>';
                    preview += '<input type="hidden" name="nombre_foto" id="nombre_foto"  value="' + $.trim(data) + '" readonly></td>';
                    preview += '<input type="hidden" name="ruta_foto_empleado" id="ruta_foto_empleado"  value="' + src + '" readonly></td>';
                    preview += '</tr>'
                    $("#previews_foto").append(preview).show(300);
                    $("#previewruta_foto_empleado").fadeIn(400);
                    aplicar_fancy();
                } else {
                    crear_alerta('error', 'Formato Incorrecto', 'El archivo es inválido');
                }
            } else { //el formato es incorrecto
                crear_alerta('error', 'Formato Incorrecto', 'El archivo es inválido');
            }
        }
    });


    $(".eliminar_imagen").live("click", function (event) {
        event.preventDefault();
        url = $(this).attr('custom');
        //id = this.id;
        // console.log(url);
        $.ajax({
            type: 'POST',
            url: urlj + 'inicio/eliminar_imagen_gral/anexos_medicos',
            data: {url: url},
            success: function (data) {
                //$("#ruta" + id_key).val("");
                $("#previewruta_foto_empleado").remove();
            }
        });
    });


    $(".eliminar_tr").live("click", function (event) {
        event.preventDefault();
        url = $(this).attr('custom');
        console.log(url);
        $.ajax({
            type: 'POST',
            url: urlj + 'inicio/eliminar_imagen_gral/anexos_medicos',
            asyn: false,
            data: { url: url },
            success: function (data) {
            }
        });
        $(this).closest("tr").remove();
    });

    $(".verAnexo").fancybox({
        openEffect  : 'elastic',
        closeEffect : 'elastic',
        href: $(this).attr('href'),
        type: 'iframe',
        width:'100%',
        height: '100%',
        closeBtn: true,
        maxHeight : 900,
        autoSize: false,
        helpers : {
            title : {
                type : 'inside'
            }
        }
    });

    $("#txtcomentario").on("change", function () {
        $("#txtcomentario").addClass("");
        $("#txtcomentario").addClass("uniform");
        $("#txtcomentario_error").text("");
    });

    $("#agregar").on("click", function () {
        event.preventDefault();
        var id = $("#cim_id").val();
        var comentario = $("#txtcomentario").val();
        var foto = $("#ruta_foto_empleado").val();
        var titulo_foto = $("#nombre_foto").val();
        if (comentario == '') {
            $("#txtcomentario").addClass("error");
            $("#txtcomentario_error").text("Campo requerido");
            return false;
        }
        var extension = (titulo_foto != undefined) ? titulo_foto.split(".") : '';
        var nombre_foto = $("#titulo_foto_empleado").val();

        var date = new Date();
        var fecha_value = date.getFullYear() + '/' + (date.getMonth() + 1) + '/' + date.getDate(); 
        var hora_value = date.getHours() + ':' + date.getMinutes() + ':' + date.getSeconds();
        var fecha_text = date.getDate() + '/' + (date.getMonth() + 1) + '/' + date.getFullYear() + ' ' + date.getHours() + ':' + date.getMinutes() + ':' + date.getSeconds();

        html = '<tr>';
        html += '<input type="hidden" name="txtsgt_id[]" id="txtsgt_id" value="" class="text tables-input-show tables-input selects-text sgc_id">'
        html += '<td>';
        html += '<label>' + fecha_text + '</label>';
        html += '<input type="hidden" name="fecha[]" id="fecha" value="' + fecha_value + '" class="nonestyle">';
        html += '<input type="hidden" name="hora[]" id="hora" value="' + hora_value + '" class="nonestyle">';
        html += '</td>';
        html += '<td>';
        html += '<input type="text" name="txtcomentario[]" id="txtcomentario" value="' + comentario + '" class="text tables-input-show tables-input selects-text ">';
        html += '</td>';
        html += '<td>';
        if (nombre_foto != undefined) {
            html += '<label><a class="verAnexo" href="' + foto + '">' + nombre_foto + '.' + extension[1] + '</a></label>';
            html += '<input type="hidden" name="ruta_foto[]" id="ruta_foto" value="temp/anexos_medicos/' + titulo_foto + '" class="nonestyle">';
            html += '<input type="hidden" name="nombre_imagen[]" id="nombre_imagen" value="' + titulo_foto + '" class="nonestyle">';
            html += '<input type="hidden" name="nombre_foto_nueva[]" id="nombre_foto_nueva" value="' + nombre_foto + '" class="nonestyle">';
        } else {
            html += '<label><a class="verAnexo" href=""></a></label>';
            html += '<input type="hidden" name="ruta_foto[]" id="ruta_foto" value="" class="nonestyle">';
            html += '<input type="hidden" name="nombre_imagen[]" id="nombre_imagen" value="" class="nonestyle">';
            html += '<input type="hidden" name="nombre_foto_nueva[]" id="nombre_foto_nueva" value="" class="nonestyle">';
        }
        html += '</td>';
        html += '<td>';
        html += '<button type="button" custom="' + titulo_foto + '" class="btn btn-danger btn-mini eliminar_tr" style="float:left;height:30px;width:50px;"><span class="wpzoom-trashcan"></span></button>';
        html += '</td>';
        html += '</tr>';

        $("table tbody[id='seguimiento_table']").append(html);
        $("#txtcomentario").val("");
        $("#previewruta_foto_empleado").remove();
        aplicar_fancy();

    });

    $("body").on("click", "#btnCrear", function(){
        event.preventDefault(); 
        var id = $("#cim_id").val();
            //cantidad de comentarios ingresados
        var cont=0;
        $('input[name^="txtcomentario"]').each(function() {
            cont++;
        });
        if (!$("#form_add").valid()) {
            return false;
        }
        if (!($("#confirmar_cita").val() != '')) {
            crear_alerta('error','Error', 'No se a cancelado ni confirmado la cita');
            wait.close();
            return false;
        }
        if(cont==0){
            crear_alerta('error','Error', 'Por favor agregue un comentario');
            saltar_tab('tab_anexo', 100);
            wait.close();
            return false;
        }
        var tipo = ($("#confirmar_cita").val() == 2) ? 'confirmación' : 'cancelación' ;
        alerta_confirm_ajax(form_submit, id,'Alerta de '+tipo,'¿Seguro que quieres aplicar la '+tipo+' de la cita? ¡No podrá editarla!');
    });


    /*$("#form_add").validate({
        ignore: "",
        rules: {
            slcpaciente: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').html(error);
        },
        submitHandler: function (form) {
            event.preventDefault(); 
            wait.start();

            var fecha = $("#txtfconsulta").val();
            var hora_desde = $("#txthdesde").val();
            var hora_hasta = $("#txthhasta").val();
            var medico = $("#slcmedico").val();
            var success = 0;
        $.ajax({
            url: urlj + 'modulo_medico/med_procesos/verificacion_horas',
            type: 'POST',
            dataType: 'json',
            async: false,
            data: {fecha : fecha,
                   hora_desde : hora_desde,
                   hora_hasta : hora_hasta,
                   medico : medico
                    },
            success:function(data){
                success = data.cim_id;
                console.log('data: '+data.cim_id);
                console.log('id_cim: '+success);              
            }
        });
                if (!($("#confirmar_cita").val() != '')) {
                    crear_alerta('error','Error', 'No se a cancelado ni confirmado la cita');
                    wait.close();
                    return false;
                }
        form.submit();
            
        }
    });*/

});

    function form_submit(id){
        // console.log('entro');
        wait.start();
        $.ajax({
            url: urlj + 'modulo_medico/med_procesos/confirmar_cita/'+id,
            type: 'POST',
            dataType: 'json',
            async: false,
            data: $("#form_add").serialize(),
            success:function(data){
                // console.log(data.cim_id);
                if (data.cim_id > 0) {
                    // console.log(data.cim_id);
                    parent.$.fancybox.close();
                    parent.location.reload();
                }
                return false;
                crear_alerta('error','Error', 'No se a cancelado ni confirmado la cita');
                wait.close();    
            }
        });
    }

    function aplicar_fancy() {
        $(".verAnexo").fancybox({
            openEffect: 'elastic',
            closeEffect: 'elastic',
            href: $(this).attr('href'),
            type: 'iframe',
            helpers: {
                title: {
                    type: 'inside'
                }
            }
        });
    }