$(document).ready(function() {
    $('#slcUbicacion, #slcEstado').select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});

    $("#txtFecha_desde,#txtFecha_hasta").change(function(event) {  validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta'); });

    setTimeout(()=> {
        $('#btnConsultar').trigger('click');
    }, 500);

    $('#btnConsultar').on('click', function(e){
        e.preventDefault();
        let slcUbicacion = $('#slcUbicacion').val();
        let slcEstado = $('#slcEstado').val();
        let txtFecha_desde = $('#txtFecha_desde').val();
        let txtFecha_hasta = $('#txtFecha_hasta').val();
        const filtros = {
            slcUbicacion, slcEstado, txtFecha_desde, txtFecha_hasta
        };
        let url_ajax = window.satelite.base_url('modulo_medico/med_procesos/grid_clasificacion_paciente');
        $.ajax({
            url: url_ajax,
            type: 'POST',
            // dataType: 'json',
            data: filtros,
            beforeSend: function() {
                wait.start();
            },
            error: function(xhr, status, error) {
            console.log('error');
                wait.close();
            },
            success: function(result) {
                $("#table-container").html($.trim(result));

                $('.grocery_table').dataTable({
                    "aaSorting": [[0, "asc"], [1, "desc"], [6, "asc"], [7, "asc"]],                  
                    "aoColumnDefs": [{ "bVisible": false, "aTargets": [0, 1] }],                    
                });              
                wait.close();
            }
        });        
    });

    $('body').on('click', '.eliminar_registro', async function(e){
        e.preventDefault();
        let url = $(this).attr('href');
        let flagContinuar = await alerta_confirmacion();
        if (!flagContinuar){
            return;
        }

        $.ajax({
            url: url,
            type: 'POST',
            dataType: 'json',
            // data: filtros,
            beforeSend: function() {
                wait.start();
            },
            error: function(xhr, status, error) {
            console.log('error', error);
                wait.close();
            },
            success: function(result) {
                if (result.respuesta) {
                    crear_alerta('success', 'Ingreso paciente', 'El ingreso paciente se eliminó correctamente.')
                    $('#btnConsultar').trigger('click');
                }         
                wait.close();
            }
        });         
    });

    $("body").on('click', '.agregar_chequeo', async function(event) {
        event.preventDefault();
        let idClasificacionPaciente = $(this).data('id');
        let url_ajax = window.satelite.base_url('modulo_medico/med_procesos/get_estado_consulta_emergencia');
        let {en_consulta, cim_id} = await requestAjax(url_ajax, 'POST', {idClasificacionPaciente});   
        if (en_consulta) {
            crear_alerta('error', 'Agregar chequeo', 'El paciente ya ha sido atendido');
            $('#btnConsultar').trigger('click');
            return;
        } 

        let url_consulta_emergencia = `${window.satelite.base_url('modulo_medico/med_procesos/consulta_emergencia')}/${idClasificacionPaciente}/${cim_id}/1`;
        window.location.href = url_consulta_emergencia;
    });    

});

const alerta_confirmacion2 = async function(message = '¿Seguro que quieres borrar este registro?'){
    let respuesta = Swal.fire({
        title: "Alerta confirmación",
        text: message,
        icon: "question",
        showCancelButton: true,
        confirmButtonColor: "#203A6F",
        cancelButtonColor: "#ff3d60",
        confirmButtonText: "SI",
        cancelButtonText: "No"
        })
        .then(function (result) {
            if (!result.value) {
                return false;
            }else{
                return true;
            }
        });
    return respuesta;
}

const requestAjax = async function(url, method, data)
{
  let response;
  try{
      response = await $.ajax({
        type: method,
        url: url,
        dataType: 'json',
        data : data,
       })
  } catch (error){
    console.log('error', error);
    crear_alerta('error', 'Error', 'Ocurrió un error al consultar los datos');
  }
  return response;
}

const alerta_confirmacion = function () {
    return new Promise((resolve) => {
        $.fancybox.open({
            href: '#modal_eliminar_paciente',
            type: 'inline',
            modal: true,
            width: '50%',
            height: '300',
            autoSize: false,
            closeClick: false,
            clickSlide: false,   // desactiva cierre al hacer clic en el fondo
            clickOutside: false, // desactiva cierre al hacer clic fuera
            keyboard: false,     // desactiva cierre con Esc
            touch: false,        // (opcional) desactiva swipe en móviles                
            afterShow: function () {
                // Limpiar eventos antiguos y asignar nuevos
                $('#confirmarLlamado').off('click').on('click', function () {
                    $.fancybox.close();
                    resolve(true); // Usuario aceptó
                });

                $('#cancelarLlamado').off('click').on('click', function () {
                    $.fancybox.close();
                    resolve(false); // Usuario canceló
                });
            },
            beforeClose: function () {
            }
        });
    });
}