$(document).ready(function() {

    $("select").select2({placeholder: 'Seleccionar...'});
    $(".datePicker").attr('placeholder', "dd-mm-yyyy");
    $(".datePicker").datepicker({
        dateFormat: 'dd-mm-yy',
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $("body").on("click", ".fancybox_modal",function() {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width:'100%',
            closeBtn: true,
            height: '100%'
        });
    });

    $(".confirmar_cita").on("click", function() {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width:'100%',
            closeBtn: true,
            height: '100%'
        });
    });

    $("#txtfdesde, #txtfhasta").on("change", function () {
        event.preventDefault();
        var fecha_desde = $("#txtfdesde").val();
        var fecha_hasta = $("#txtfhasta").val();

        var fecha_i = fecha_desde.split("-").reverse().join("-");
        var fecha_f = fecha_hasta.split("-").reverse().join("-");

        if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
            crear_alerta('error', 'Formato Incorrecto', 'las fecha desde no puede ser mayor o igual que la fecha hasta');
            $("#txtfdesde").val("");
            $("#txtfhasta").val("");
            return false;
        }
    });

    $("body").on("click", "#btnConsultar", function(){
        event.preventDefault();
        $(".xprt").hide();
        $("#citas_table").hide("slide", {direction: 'left'}, 400); //Se obtienen los detalles del Cliente
        $.ajax({
            dataType: 'json',
            type: 'post',
            data: $("#frmcumsultaform").serialize(),
            url: urlj + 'modulo_medico/med_procesos/citas_medicas',
            async: false,
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                var oTabla = $("#tbl_contenedor").dataTable();
                oTabla.fnDestroy();
                $("#tbContenedor").html(data.tabla);
                aplidarDataTable('tbl_contenedor');
                if (data.filas > 0) {
                    $("#estados").val($("#slcestado").val());
                    $("#fecha_d").val($("#txtfdesde").val());
                    $("#fecha_h").val($("#txtfhasta").val());
                    $("#xpednte").val($("#slcpaciente").val());
                    $("#exc").show();
                    if (data.filas <= 500) {
                        $("#pdf").show();
                    }
                }
                $("#citas_table").show("slide", {direction: 'right'}, 500);
                wait.close();
            }
        });
    });

    $("#slcpaciente").select2({
        placeholder: "Buscar Paciente...",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_medico/med_procesos/get_pacientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
                return {
                    categoria: categoria
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.epp_id,
                        'text': item.epp_numero_expediente+' - '+item.epp_nombre+' '+item.epp_apellido+' '+item.epp_apellido_casada
                    });
                });
                setTimeout(function() {

                },200)
                return {
                    results: myResults
                };
            },
        }
    });

});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}