$(document).ready(function() {
    
    $("select").select2({placeholder: 'Seleccione'});
    
    $(".datePicker").datepicker({
        dateFormat: 'dd-mm-yy',
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").attr('placeholder', "dd-mm-yyyy");
    $(".datePicker").mask("99-99-9999");

    $(".timepicker").timepicker({timeFormat: 'H:mm:ss'});
    $(".timepicker").mask('99:99:99');
    $(".timepicker").attr('placeholder', 'ejemplo: 08:00:00');

    $("#slc_tipo_procedimiento").on('change', function(){
        if (  $(this).val() != "") {
            $.ajax({
                url: urlj + 'modulo_medico/med_procesos/get_duracion_prom',
                type: 'POST',
                data: {id : $(this).val()},
                success:function(data){
                    if (data != "") {
                        $("#txt_horas").val($.trim(data)); 
                    } else {
                        $("#txt_horas").val("");
                    }
                }
            });                   
        } else {
            $("#txt_horas").val("");
        }        
    });

    $(".plus").on("click", function() {
        event.preventDefault();
        var url = $(this).attr('href');
        var alto = ($(this).attr('width') != undefined) ? $(this).attr('width') : '100%'; 
        var ancho = ($(this).attr('height') != undefined) ? $(this).attr('height') : '100%'; 
        console.log(alto);
        console.log(ancho);
        $.fancybox({
            'href': url,
            type: 'iframe',
            width: '100%',
            closeBtn: true,
            height: '100%'
        }); 
    });

    $("#slc_paciente").on('change',function() {
        var id = $(this).val();
        get_medico(id);
    });

    $("#slc_paciente").select2({
        placeholder: "Buscar Paciente...",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_medico/med_procesos/get_pacientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
               return {
                    categoria: categoria
                };
            },
            results: function (data) {
                console.log(data);
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.epp_id,
                        'text': item.epp_numero_expediente + ' - ' + item.epp_nombre + ' ' + item.epp_apellido + ' ' + item.epp_apellido_casada
                    });
                });
                setTimeout(function() {

                },200)
                return {
                    results: myResults
                };

            },
            initSelection: function (element, callback) {
                var idElemento = element[0].id;
                var valor = $("#" + idElemento).val();
                if (valor !== "") {
                    var texto = $("#" + idElemento).data('nombre');
                    callback({id: valor, text: texto});
                }
            }
        }
    });

    $("#slc_especialidad").select2({
        placeholder: "Buscar especialidad...",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_medico/med_procesos/get_campos_like/epm_especialidad_medica',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
                return {
                    categoria: categoria,
                    campo : 'epm_estado = 1 AND epm_nombre'
                };
            },
            results: function (data) {
                console.log(data);
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.epm_id,
                        'text': item.epm_nombre
                    });
                });
                setTimeout(function () {

                }, 200)
                return {
                    results: myResults
                };

            },
            initSelection: function (element, callback) {
                var idElemento = element[0].id;
                var valor = $("#" + idElemento).val();
                if (valor !== "") {
                    var texto = $("#" + idElemento).data('nombre');
                    callback({ id: valor, text: texto });
                }
            }
        }
    });

    $("#slc_tipo_procedimiento").select2({
        placeholder: "Buscar Tipo Procedimiento...",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_medico/med_procesos/get_campos_like/pcm_procedimiento_medico',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
                return {
                    categoria: categoria,
                    campo: 'pcm_estado = 1 AND pcm_nombre'
                };
            },
            results: function (data) {
                console.log(data);
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.pcm_id,
                        'text': item.pcm_nombre
                    });
                });
                setTimeout(function () {

                }, 200)
                return {
                    results: myResults
                };

            },
            initSelection: function (element, callback) {
                var idElemento = element[0].id;
                var valor = $("#" + idElemento).val();
                if (valor !== "") {
                    var texto = $("#" + idElemento).data('nombre');
                    callback({ id: valor, text: texto });
                }
            }
        }
    });

    $("#slc_medico").select2({
        placeholder: "Buscar Medico...",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_medico/med_procesos/get_medico_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
                return {
                    categoria: categoria,
                    campo: 'med_estado = 1 AND tmd_principal = 1 AND med_nombre'
                };
            },
            results: function (data) {
                console.log(data);
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.med_id,
                        'text': item.med_nombre
                    });
                });
                setTimeout(function () {

                }, 200)
                return {
                    results: myResults
                };

            },
            initSelection: function (element, callback) {
                var idElemento = element[0].id;
                var valor = $("#" + idElemento).val();
                if (valor !== "") {
                    var texto = $("#" + idElemento).data('nombre');
                    callback({ id: valor, text: texto });
                }
            }
        }
    });

    $("#slc_anestesiologo").select2({
        placeholder: "Buscar Anestesiólogo...",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_medico/med_procesos/get_medico_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
                return {
                    categoria: categoria,
                    campo: 'med_estado = 1 AND tmd_anestesia = 1 AND med_nombre'
                };
            },
            results: function (data) {
                console.log(data);
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.med_id,
                        'text': item.med_nombre
                    });
                });
                setTimeout(function () {

                }, 200)
                return {
                    results: myResults
                };

            },
            initSelection: function (element, callback) {
                var idElemento = element[0].id;
                var valor = $("#" + idElemento).val();
                if (valor !== "") {
                    var texto = $("#" + idElemento).data('nombre');
                    callback({ id: valor, text: texto });
                }
            }
        }
    });

    $("#slc_ayudante").select2({
        placeholder: "Buscar Ayudante...",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_medico/med_procesos/get_medico_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
                return {
                    categoria: categoria,
                    campo: 'med_estado = 1 AND tmd_ayudante = 1 AND med_nombre'
                };
            },
            results: function (data) {
                console.log(data);
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.med_id,
                        'text': item.med_nombre
                    });
                });
                setTimeout(function () {

                }, 200)
                return {
                    results: myResults
                };

            },
            initSelection: function (element, callback) {
                var idElemento = element[0].id;
                var valor = $("#" + idElemento).val();
                if (valor !== "") {
                    var texto = $("#" + idElemento).data('nombre');
                    callback({ id: valor, text: texto });
                }
            }
        }
    });

    $("#form_add").validate({
        ignore: "",
        rules: {
            slc_paciente: {required: true}
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').text('Campo requerido');           
        },
        submitHandler: function (form) {
            wait.start();
          
            form.submit();
        }
    });

});

function get_medico(id){
    $.ajax({
        url: urlj + 'modulo_medico/med_procesos/get_medico',
        type: 'POST',
        dataType: 'json',
        data: {id : id},
        success:function(data){
            if (data.epp_id_med != null) {
                $('#slcmedico').select2('destroy');
                $('#slcmedico').val(data.epp_id_med);
                $('#slcmedico').select2();
                $('#slcmedico').select2({placeholder: 'Seleccione'});
            }
        }
    });
}