$(document).ready(function() {
    // Configuración inicial de select2 y datepicker
    $("select").select2({ placeholder: 'Seleccionar...' });
    $("#txtFechaConstancia").mask("99-99-9999");
    $("#txtFechaConstancia").attr('placeholder', "dd-mm-yyyy").removeClass('hasDatepicker').datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
    });

    
    const cnm_id = $("#cnm_id").val();
    const saveInterval = 30000; // Guardar cada 30 segundos
    let isOnline = navigator.onLine;
    const storageKey = `consulta_draft_${cnm_id}`;
    const urlj = window.urlj; 

    // Configuración de subida de anexos
    var ruta = urlj + 'inicio/guardar_gral/anexos_medicos';
    new FUload('btn_foto_inventario', ruta, {
        start: function(file) {
            wait.start();
        },
        sucess: function(data) {
            wait.close();
            if ($.trim(data) != "") {
                var a_exten = $.trim(data).split('.');
                var exten = a_exten[a_exten.length - 1].toLowerCase();
                if (exten == 'jpg' || exten == 'jpeg' || exten == 'png' || exten == 'pdf') {
                    $("#previews_foto").empty();
                    var src = (exten == 'pdf') ? urlj + 'media/imagenes/sistema/' + exten + '.png' : urlj + 'public/temp/anexos_medicos/' + $.trim(data);
                    var preview = "<tr id='previewruta_foto_empleado' style='display:none;' class='preview_documento'>";
                    preview += '<td><a title="Ver Anexo" class="fancy_modal" href="' + urlj + 'public/temp/anexos_medicos/' + $.trim(data) + '">';
                    preview += '<img id="img_pre" src="' + src + '" width="88" height="88" class="imagen_documento"></a></td>';
                    preview += '<td><input maxlength="75" style="width:50%;" class="titulo_documento" type="text" name="titulo_foto_empleado" id="titulo_foto_empleado" value="' + a_exten[0] + '"><span style="display:none;font-size:11px;color:red;margin-top:-10%" class="texto" id="titulo_foto_empleado"></span><br><small style="text-align:left;">Nombre del documento</small></td>';
                    preview += '<td style="vertical-align:middle !important; width:30px !important;"><img style="display:none;" src="' + urlj + 'media/editar_documento.png" title="Editar" value="titulo_foto_empleado" class="editar_documento"/></td>';
                    preview += '<td style="background:#E1E7F0!important;"><a href="javascript:void(0);" title="Eliminar Anexo" class="eliminar_imagen" custom="' + $.trim(data) + '" custom_id=""><img class="quitar_documento" src="' + urlj + 'media/eliminar_documento.png" title="Eliminar documento"></a>';
                    preview += '<input type="hidden" name="ruta_foto_empleado" id="ruta_foto_empleado" value="' + $.trim(data) + '" readonly></td>';
                    preview += '</tr>';
                    $("#previews_foto").append(preview).show(300);
                    $("#previewruta_foto_empleado").fadeIn(400);
                } else {
                    crear_alerta('error', 'Formato Incorrecto', 'Tipo de archivo inválido');
                    $.ajax({
                        type: 'POST',
                        url: urlj + 'inicio/eliminar_imagen_gral/anexos_medicos',
                        data: { url: $.trim(data) },
                        success: function(data) {
                            console.log('Se eliminó el archivo con error');
                        }
                    });
                }
            } else {
                crear_alerta('error', 'Formato Incorrecto', 'El archivo es inválido');
            }
        }
    });

    // Detectar cambios en la conexión
    window.addEventListener('online', () => {
        isOnline = true;
        syncLocalData();
        crear_alerta('success', 'Conexión Restaurada', 'La conexión a internet ha sido restaurada.');
    });
    window.addEventListener('offline', () => {
        isOnline = false;
        crear_alerta('warning', 'Sin Conexión', 'Se ha perdido la conexión a internet. Los datos se guardarán localmente.');
    });

    // Guardado periódico
    setInterval(() => {
        if (isOnline) {
            saveDraft();
        } else {
            saveToLocalStorage();
        }
    }, saveInterval);

    // Guardar borrador al servidor
    function saveDraft($es_chequeo = false) {
        $("#action").val('save_draft');
        $.ajax({
            url: $("#form_add").attr("action"),
            type: 'POST',
            dataType: 'json',
            data: $("#form_add").serialize(),
            success: function(response) {
                if (response.status === 'success') {
                    localStorage.removeItem(storageKey); // Limpiar almacenamiento local tras guardar
                    console.log('Los datos se han guardado correctamente en el borrador');
                    if ($es_chequeo) {
                        window.location = window.satelite.base_url('modulo_medico/med_procesos/clasificacion_paciente');
                    }
                    //crear_alerta('success', 'Guardado Automático', 'Los datos se han guardado correctamente en el servidor.');
                }
            },
            error: function() {
                isOnline = false;
                saveToLocalStorage();
                crear_alerta('error', 'Error de Conexión', 'No se pudo guardar en el servidor. Los datos se han almacenado localmente.');
            }
        });
    }

    // Guardar en localStorage
    function saveToLocalStorage() {
        const formData = $("#form_add").serializeArray();
        localStorage.setItem(storageKey, JSON.stringify(formData));
    }

    // Sincronizar datos locales al reconectar
    function syncLocalData() {
        const localData = localStorage.getItem(storageKey);
        if (localData) {
            $("#action").val('save_draft');
            $.ajax({
                url: $("#form_add").attr("action"),
                type: 'POST',
                dataType: 'json',
                data: JSON.parse(localData),
                success: function(response) {
                    if (response.status === 'success') {
                        localStorage.removeItem(storageKey);
                        crear_alerta('success', 'Sincronización Completa', 'Los datos locales han sido sincronizados con el servidor.');
                    }
                },
                error: function() {
                    crear_alerta('error', 'Error de Sincronización', 'No se pudo sincronizar los datos locales. Intentando de nuevo en 30 segundos.');
                }
            });
        }
    }

    // Eliminar imagen
    function eliminar_imagen(url, tr) {
        $.ajax({
            type: 'POST',
            url: urlj + 'inicio/eliminar_imagen_gral/anexos_medicos',
            data: { url: url },
            success: function(data) {
                tr.remove();
            }
        });
    }

    // Funcionalidad de eliminación de imagen
    $("body").on("click", ".eliminar_imagen", function(event) {
        event.preventDefault();
        var url = $(this).attr('custom');
        var tr = $(this).closest('tr');
        console.log(url);
        eliminar_imagen(url, tr);
    });

    // Abrir fancybox para anexos
    $("body").on("click", ".fancy_modal", function(event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width: '100%',
            closeBtn: true,
            height: '100%',
            maxHeight: 900,
            autoSize: false
        });
    });

    if ($("#txtFechaNacimiento").val() != "") {
        var text_edad = "";
        var edad = calcular_edad($("#txtFechaNacimiento").val());
        text_edad += (edad["year"] != undefined) ? edad["year"] : '';
        text_edad += (edad["mes"] != undefined) ? edad["mes"] : '';
        text_edad += (edad["dia"] != undefined) ? edad["dia"] : '';
        $("#txtEdad").val(text_edad);
    }

    $("body").on("click", ".modal_imagen",function() {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            'type': 'image',
            'closeBtn': true,
            'width': '200',
            'height': 'auto',
            'autoSize': false
        });
    });

    // Contador de caracteres para diagnóstico
    $("body").on("keyup", "#txadiagnostico", function() {
        var cantidad = 2000 - $(this).val().length;
        $("#label_diagnostico").text('Diagnóstico: (' + cantidad + ')');
    });

    // Contador de caracteres para preautorización
    $("body").on("keyup", "#txtpreautorizacion", function() {
        var cantidad = 2000 - $(this).val().length;
        $("#label_preautorizacion").text('Pre-autorización de exámenes y estudios de gabinete: (' + cantidad + ')');
    });

    // Eliminar filas de tablas
    $("body").on("click", ".eliminar_tr", function() {
        $(this).closest('tr').remove();
    });

    $("body").on("click", ".eliminar_tr2", function() {
        $(this).closest('tr').remove();
        obtenerNumFilas();
    });

    // Actualizar presentación de medicamento
    $("body").on("change", "#slcmedicamento", function() {
        var id = $(this).val();
        if (id != '') {
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: urlj + 'modulo_medico/med_procesos/get_presentacion',
                data: { id: id },
                success: function(data) {
                    console.log(data.ppr_nombre);
                    $("#presentacion").val(data.ppr_nombre);
                    $("#medicamento_nombre").val(data.art_nombre + ' (' + data.art_sinonimo + ')');
                }
            });
        } else {
            $("#presentacion").val('');
            $("#medicamento_nombre").val('');
        }
    });

    // Agregar anexo
    $("body").on("click", "#agregar", function(event) {
        event.preventDefault();
        var date = new Date();
        var fecha_value = $.datepicker.formatDate('yy-mm-dd', date);
        var fecha_title = $.datepicker.formatDate('dd/m/yy', date);
        var hora = date.toLocaleTimeString();
        var hour = date.toLocaleTimeString('en-US', { hour12: false });
        var comentario = $('#txtcomentario').val();
        var ruta = $('#ruta_foto_empleado').val();
        var titulo = $('#titulo_foto_empleado').val();
        if (!$.trim(titulo)) {
            crear_alerta("error", "", "Nombre del Anexo no debe quedar vacío");
            return false;
        }
        var extension = (typeof ruta != "undefined") ? ruta.split('.') : [];
        var html = '<tr>';
        html += '<td><label>' + fecha_title + ' ' + hora + '</label>';
        html += '<input type="hidden" name="txtfecha[]" value="' + fecha_value + ' ' + hour + '" class="txtfecha">';
        html += '</td>';
        html += '<td><input type="text" name="txtcomentarioanex[]" value="' + comentario + '" class="text tables-input-show tables-input selects-text "></td>';
        html += '<td>';
        if (!$.isEmptyObject(extension)) {
            html += '<label><a class="fancy_modal" href="' + urlj + 'public/temp/anexos_medicos/' + ruta + '">' + titulo + '.' + extension[1] + '</a></label>';
        }
        html += '<input type="hidden" name="txtruta[]" value="' + ruta + '" class="txtruta">';
        html += '<input type="hidden" name="txtnombreanex[]" value="' + titulo + '" class="txtnombreanex">';
        html += '</td>';
        html += '<td><button type="button" class="btn btn-danger btn-mini eliminar_imagen" custom="' + ruta + '" style="float:left;height:30px;width:50px;"><spanShut down your computer, or put it to sleep. class="wpzoom-trashcan"></span></button></td>';
        html += '</tr>';
        $("#anexo_previews").append(html);
        $('#txtcomentario').val('');
        $('#previewruta_foto_empleado').remove();
    });

    // Agregar medicamento
    $("body").on("click", ".agregar_medicamento", function() {
        var medicamento = $("#slcmedicamento").val();
        var medicamento_texto = $("#medicamento_nombre").val();
        var presentacion = $("#presentacion").val();
        var cantidad = $("#cantidad").val();
        var dosis = $("#dosis").val();
        var comentarios = $("#comentarios").val();
        if (medicamento != '' && dosis != '') {
            var html = '<tr>';
            html += '<td><label>' + medicamento_texto + '</label>';
            html += '<input type="hidden" name="txtmedicamento[]" value="' + medicamento + '" class="txtmedicamento"></td>';
            html += '<td><label>' + presentacion + '</label>';
            html += '<input type="hidden" name="txtpresentacion[]" value="' + presentacion + '" class="text tables-input-show tables-input selects-text "></td>';
            html += '<td><input type="text" name="txtcantidad[]" value="' + cantidad + '" class="text tables-input-show tables-input selects-text "></td>';
            html += '<td><input type="text" name="txtdosis[]" value="' + dosis + '" class="text tables-input-show tables-input selects-text "></td>';
            html += '<td><input type="text" name="txtcomentariomed[]" value="' + comentarios + '" class="text tables-input-show tables-input selects-text "></td>';
            html += '<td><button type="button" class="btn btn-danger btn-mini eliminar_tr2" style="float:left;height:30px;width:50px;"><span class="wpzoom-trashcan"></span></button></td>';
            html += '</tr>';
            $("#table_medicamentos").append(html);
            $("#slcmedicamento").select2("val", "");
            $("#presentacion").val('');
            $("#cantidad").val('');
            $("#dosis").val('');
            $("#comentarios").val('');
            $("#medicamento_nombre").val('');
            obtenerNumFilas();
        } else {
            crear_alerta('error', 'Recetas', 'Verifique medicamento y dosis');
        }
    });

    // Configuración de select2 para medicamentos
    $("#slcmedicamento").select2({
        placeholder: "Seleccionar...",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_medico/med_procesos/get_articulo_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
               return {
                    nombre: categoria,
                    bodega: $("#bodega_consultorio").val()
                };
            },
            results: function(data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    var mep_nomb = (item.saldo != '') ? ' - '+item.medida : '';
                    var cantidad = (item.saldo != '' && (+item.saldo > 0)) ? ' ('+item.saldo+mep_nomb+')' : '';
                    myResults.push({
                        'id': item.art_id,
                        'text': item.art_codigo+' - '+item.art_nombre+cantidad
                    });
                });
                return { results: myResults };
            }
        },
        initSelection: function(element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({ id: valor, text: texto });
            }
        }
    });

    function pingServer(callback) {
        $.ajax({
            url: $("#input_ping").val(),
            type: 'GET',
            timeout: 5000, // 5 segundos de timeout
            success: function() {
                callback(true);
            },
            error: function() {
                callback(false);
            }
        });
    }

    // Guardado final
    $("body").on("click", "#btnmodalguardar, .btn_enviar", function() {
        event.preventDefault();
        wait.start();
        $("#action").val('save_final');
        /*if (!isOnline) {
            saveToLocalStorage();
            crear_alerta('warning', 'Sin Conexión', 'No se pudo guardar la consulta debido a la falta de conexión. Los datos se han almacenado localmente y se sincronizarán al reconectar.');
            wait.close();
            return false;
        }
        $.ajax({
            url: $("#form_add").attr("action"),
            type: 'POST',
            dataType: 'text',
            async: false,
            data: $("#form_add").serialize(),
            success: function(data) {
                if (data > 0) {
                    localStorage.removeItem(storageKey);
                    if ($("#modulo").val() > 0) {
                        parent.$.fancybox.close();
                        parent.location.reload();
                    } else {
                        window.location.href = urlj + 'modulo_medico/med_procesos/consulta_medica';
                    }
                } else {
                    crear_alerta('error', 'Error', 'Fallo al almacenar la consulta, inténtelo más tarde');
                }
                wait.close();
            },
            error: function() {
                saveToLocalStorage();
                crear_alerta('error', 'Error de Conexión', 'No se pudo guardar la consulta. Los datos se han almacenado localmente y se sincronizarán al reconectar.');
                wait.close();
            }
        });*/

        pingServer(function(ping_retornado) {
            if (ping_retornado) {
                $.ajax({
                    url: $("#form_add").attr("action"),
                    type: 'POST',
                    dataType: 'json',
                    async: false,
                    data: $("#form_add").serialize(),
                    success: function(data) {
                        console.log('Respuesta del servidor:', data);
                        if (data.status === 'success' && data.cnm_id > 0) {
                            localStorage.removeItem(storageKey);
                            if (data.modal > 0) {
                                parent.$.fancybox.close();
                                parent.location.reload();
                            } else if (data.redirect) {
                                window.location.href = data.redirect;
                            }
                        } else {
                            console.log('Error: Respuesta no válida:', data);
                            crear_alerta('error', 'Error', data.message || 'Fallo al almacenar la consulta, inténtelo más tarde');
                        }
                        wait.close();

                    },
                    error: function() {
                        saveToLocalStorage();
                        crear_alerta('error', 'Error de Conexión', 'No se pudo guardar la consulta. Los datos se han almacenado localmente y se sincronizarán al reconectar.');
                        wait.close();
                    }
                });
            } else {
                saveToLocalStorage();
                crear_alerta('warning', 'Sin Conexión', 'No se pudo guardar la consulta debido a la falta de conexión. Los datos se han almacenado localmente y se sincronizarán al reconectar.');
                wait.close();
            }
        });
    });

    // Calcular peso en kg
    var peso = $('#txtpeso').val();
    if (peso > 0) {
        var pesokg = peso / 2.20462262;
        $('#txtpesokg').val(round_number(pesokg, 2) + ' Kg');
    }

    $('#txtpeso').keyup(function() {
        var peso = $('#txtpeso').val();
        if (peso > 0) {
            var pesokg = peso / 2.20462262;
            $('#txtpesokg').val(round_number(pesokg, 2) + ' Kg');
        }
    });

    // Calcular IMC
    $('#txttalla').keyup(function() {
        var pesokg = $('#txtpesokg').val();
        var res = pesokg.replace("Kg", '').trim();
        console.log(res);
        var talla = Math.pow($('#txttalla').val(), 2);
        if (res > 0 && talla > 0) {
            var imc = res / talla;
            $('#txtimpc').val(trunc(imc, 2));
        }
    });

    // Función para truncar decimales
    function trunc(x, posiciones = 0) {
        var s = x.toString();
        var decimalLength = s.indexOf('.') + 1;
        var numStr = s.substr(0, decimalLength + posiciones);
        return Number(numStr);
    }

    // Contar filas de medicamentos
    function obtenerNumFilas() {
        var nFilas = $("#table_medicamentos tr").length;
        $("#medicamentos_agregados").text('(' + nFilas + ')' + ' medicamento(s) agregado(s)');
    }

    // Inicializar sincronización si hay datos locales
    syncLocalData();
    obtenerNumFilas();
    $('#btn_guardar_chequeo').on('click', function(e){
        e.preventDefault();
        saveDraft(true);
    })
});

function calcular_edad(fecha) {
    var date = new Date(fecha.replace(/(\d{2})-(\d{2})-(\d{4})/, "$2/$1/$3"))
    var today = new Date();
    var birthDate = new Date(date);
    var age = today.getFullYear() - birthDate.getFullYear();
    var day = today.getDate() - birthDate.getDate();
    var m = today.getMonth() - birthDate.getMonth();
    var fecha = [];
    if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
        age--;
    }
    fecha['year'] = age + ' Años ';
    if(m > 0 ) {
        fecha['mes'] = m + ' Meses ';
    } 
    if (day > 0) {
        fecha['dia'] = day + ' Dias ';
    }
    if (isNaN(age)){
        return false;
    }
    return fecha;
}