$(document).ready(function() {

    $("select").select2({placeholder: 'Seleccionar...'});
    $(".datePicker").attr('placeholder', "dd-mm-yyyy");
    $(".datePicker").datepicker({
        dateFormat: 'dd-mm-yy',
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $(".timepicker").timepicker({timeFormat: 'H:mm:ss'});
    $(".timepicker").mask('99:99:99');
    $(".timepicker").attr('placeholder', 'ejemplo: 08:00:00');

    $('.horas').timeEntry({
        show24Hours: false,
        showSeconds: false,
        spinnerIncDecOnly: true,
        spinnerImage: ' ',
        ampmPrefix: ' '
    });

    $("#agregar_expediente").on("click", function() {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width:'100%',
            closeBtn: true,
            height: '100%'
        }); 
    });

    $("#slcpaciente").live('change',function() {
        var id = $(this).val();
        get_medico(id);
    });

    $("#slcpaciente").select2({
        placeholder: "Buscar Paciente...",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_medico/med_procesos/get_pacientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
                return {
                    categoria: categoria
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.epp_id,
                        'text': item.epp_numero_expediente + ' - ' + item.epp_nombre+ 
                        ' ' + item.epp_apellido+ ' ' + item.epp_apellido_casada
                    });
                });
                setTimeout(function() {

                },200)
                return {
                    results: myResults
                };

            },
            initSelection: function (element, callback) {
                var idElemento = element[0].id;
                var valor = $("#" + idElemento).val();
                if (valor !== "") {
                    var texto = $("#" + idElemento).data('nombre');
                    callback({id: valor, text: texto});
                }
            }
        }
    });

    $("#form_add").validate({
        ignore: "",
        rules: {
            slcpaciente: {required: true},
            slctipoconsulta: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').html(error);
        },
        submitHandler: function (form) {
            event.preventDefault(); 
            wait.start();
            var fecha = $("#txtfconsulta").val();
            var fecha_split = fecha.split("-");
            var hora_desde = $("#txthdesde").val();
            var hora_hasta = $("#txthhasta").val();
            var medico = $("#slcmedico").val();
            var lugar = $("#slclugar").val();
            var paciente = $("#slcpaciente").val();
            var tipo_consulta = $("#slctipoconsulta").val();
            var success = 0;
            var date = new Date();
            var hora_inicio = new Date(fecha_split[1]+'/'+fecha_split[0]+'/'+fecha_split[2]+' '+hora_desde).getTime();
            var hora_fin =  new Date(fecha_split[1]+'/'+fecha_split[0]+'/'+fecha_split[2]+' '+hora_hasta).getTime();
            if (hora_fin < hora_inicio) {
                crear_alerta('error','Horas Incorrecto', 'Las hora hora hasta no puede ser mayor que la hora desde');
                $("#txthdesde").val('');
                $("#txthhasta").val('');
                wait.close();
                return false;
            }
            $.ajax({
                url: urlj + 'modulo_medico/med_procesos/verificacion_horas',
                type: 'POST',
                dataType: 'json',
                async: false,
                data: {
                    lugar: lugar,
                    fecha : fecha,
                    medico : medico,
                    paciente: paciente,
                    hora_desde : hora_desde,
                    hora_hasta : hora_hasta,
                    tipo_consulta: tipo_consulta
                },
                beforeSend: function(){
                    wait.start();
                },
                success:function(data){
                    success = data.cim_id;             
                }
            });             
            if (success > 0) {
                crear_alerta('error', "Horario no disponible", "Las horas elegidas no estan disponibles.<br>Por favor escoger otro horario");
                var hora_desde = $("#txthdesde").val('');
                var hora_hasta = $("#txthhasta").val('');
                wait.close();
                return false;
            }
            form.submit();
        }
    });


    $('#slcmedico, #txtfconsulta, #slctipoconsulta').on("change", function(){
        verificar_horario();
    });

    $("#txthdesde, #txthhasta").blur(function(){
        verificar_horario();
    });

});

function get_medico(id){
    $.ajax({
        url: urlj + 'modulo_medico/med_procesos/get_medico',
        type: 'POST',
        dataType: 'json',
        data: {id : id},
        success:function(data){
            if (data.epp_id_med != null) {
                $('#slcmedico').select2('destroy');
                $('#slcmedico').val(data.epp_id_med);
                $('#slcmedico').select2();
                $('#slcmedico').select2({placeholder: 'Seleccionar...'});
            }
        }
    });
}

function verificar_horario() {
    var medico = $("#slcmedico").val();
    var fecha = $("#txtfconsulta").val();
    var hora_desde = $("#txthdesde").val();
    var hora_hasta = $("#txthhasta").val();
    var tipo_consulta = $("#slctipoconsulta").val();
    $.ajax({
        url: urlj + 'modulo_medico/med_procesos/verificacion_horas',
        type: 'POST',
        dataType: 'json',
        async: false,
        data: {
            fecha: fecha,
            medico: medico,
            hora_desde: hora_desde,
            hora_hasta: hora_hasta,
            tipo_consulta: tipo_consulta
        },
        beforeSend: function(){
            wait.start();
        },
        success:function(data){
            if(data.cim_id!=0){
                crear_alerta('error', "Horario no disponible", "Las horas elegidas no estan disponibles.<br>Por favor escoger otro horario");
                $("#txthdesde").val('');
                $("#txthhasta").val('');
            }          
            wait.close();
            return false;
        }
    });
}