$(document).ready(function(){

    setTimeout(()=> {
        $('#btnConsultar').trigger('click');
    }, 500);

    $('#slcUbicacion, #slcMedico').select2();

    $('body').on('click', '.switch-container', function (){
        let idRegistro = $(this).data('id');
        let valorRegistro = $(this).data('valor');

        if (idRegistro) {
            $.ajax({
                url: window.gSateliteWhite.baseUrl('modulo_medico/med_mantenimientos/cambiar_estado_disponible'),
                type: 'post',
                data: {
                    idRegistro, valorRegistro
                },
                dataType : 'json',
                beforeSend: function(){
                    wait.start();
                },
                success: (response) => {
                    console.log(response);
                    crear_alerta('success', 'Estado consultorio', 'Estado de consultorio actualizado corectamente');
                    if (response.exito) {
                        if ($(this).hasClass('switch-on')){
                            $(this).removeClass('switch-on');
                            $(`#switch-label-${idRegistro}`).text('No');
                            $(this).data('valor', 0);
                        } else {
                            $(this).addClass('switch-on');
                            $(`#switch-label-${idRegistro}`).text('Si');
                            $(this).data('valor', 1);
                        }                        
                    }
                },
                complete: function (){
                    wait.close();
                }
            });
        }
    });

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
        },
        messages: {
        },
        ignore: ".select2-container",
        errorPlacement: function(error, element) {
            if (element.is('select')) {
                $(element).next().append(error);
            } else {
                    //$(element).next().append(error);
                error.insertAfter(element);
                    //$("#error_fecha").html(error);
            }
        },
        submitHandler: function(form) {
            let url_ajax = window.satelite.base_url('modulo_medico/med_mantenimientos/configuracion_consultorio');
            $.ajax({
                url: url_ajax,
                type: 'POST',
                    //dataType: 'json',
                data: {
                    slcUbicacion: $("#slcUbicacion").val(),
                    slcMedico: $("#slcMedico").val(),
                    flag: $("#flag").val(),
                },
                beforeSend: function() {
                    wait.start();
                },
                error: function(xhr, status, error) {
                    wait.close();
                },
                success: function(result) {
                    $("#contenedorTabla").html($.trim(result));
                    $(".dynamicTable").dataTable();
                    wait.close();
                }
            });
        }
    });

    $("body").on("click", ".llamar_paciente", function(event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'width': '90%',
            'height' : '80%',
            'autoScale': true,
            openEffect  : 'elastic',
            closeEffect : 'elastic',
            closeClick: false,
            helpers:{
                overlay:{closeClick:false}
            },
            'href':  url,
            'type': 'iframe',
            keys: {
                esc: null // Disable the ESC key functionality
            },
            afterClose: function (opts) { 
                validarConsultaPaciente();
            }
        });

    });   
}); 

async function validarConsultaPaciente(){
    let idPaciente = sessionStorage.getItem('idPaciente');
    sessionStorage.removeItem('idPaciente');
    if (idPaciente) {
        let url_ajax = window.satelite.base_url('modulo_medico/med_procesos/validarConsultaClasificacionPaciente/' + idPaciente);
        wait.start();
        let response = await requestAjax(url_ajax, 'GET', {});   
        wait.close();
        console.log(response);     
    }
}

const requestAjax = async function(url, method, data)
{
  let response;
  try{
      response = await $.ajax({
        type: method,
        url: url,
        dataType: 'json',
        data : data,
       })
  } catch (error){
    console.log('error', error);
    crear_alerta('error', 'Error', 'Ocurrió un error al consultar los datos');
  }
  return response;
}