var urlj = url_base_proyecto;
$(document).ready(function () {
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');
    $('select').select2({placeholder: 'Seleccione una opción'});

    if ($("#hdnVerDetalle").val() > 0) {
        $("button").hide();
        $('input').attr('readonly', 'readonly');
        $("input").attr('disabled', 'disabled');
        $("textarea").attr('disabled', 'disabled');
        $("select").select2('disable');
        $("a").hide();
        $(".form-actions").hide();
    }

    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        minDate: 0
    });

    var carpeta = $('#hdnFoto').val();
    var ruta = urlj + 'modulo_gestion_documental/procesos/guardar_gral/' + carpeta;
    new FUload('btnFoto', ruta, {
        start: function (file) {
            wait.start();
        }, sucess: function (jsonFile) {
            wait.close();
            if ($.trim(jsonFile) != "") {
                dataFile = jQuery.parseJSON(jsonFile);
                var data = dataFile.file_name;

                $("#txtTamanio").val(formatBytes(dataFile.file_size));
                $("#hdnTamanio").val(dataFile.file_size);

                //obtener la extención
                exten = dataFile.file_ext.toLowerCase().replace('.', '');
                //Se marca el tipo si existe
                $("#slcTipo option[data-extension='" + dataFile.file_ext + "']").attr('selected', 'selected');
                $("#slcTipo").select2();


                var target = "";
                var clase = "";
                var modal = "";

                if (exten == 'jpg' || exten == 'jpeg' || exten == 'png' || exten == 'pdf' || exten == 'gif') {
                    clase = "pdf";
                    target = "";
                    modal = "ver_en_modal_ajax_";
                } else {
                    clase = "";
                    target = "target=_blank";
                    modal = "";
                }

                $(".galleryView").empty();

                var archivo = "<li id='anexo' style='text-align: center;'>";
                archivo += "<input type='hidden' id='hdnArchivo' name='hdnArchivo' value='" + $.trim(data) + "' />"
                archivo += "<a " + target + " class='" + clase + " btn tooltip_pdf " + modal + "' style='width:300px; text-align:left;'";
                archivo += "href='" + urlj + "public/temp/" + carpeta + "/" + $.trim(data) + "'";
                archivo += " title='" + $.trim(data) + "'>" + "<span class='icon16 icomoon-icon-zoom-in black'></span>" + $.trim(data) + "</a>";
                archivo += "<a class='delete_anexo eliminar_imagen_foto' href='#' custom='" + $.trim(data) + "' ><span class='icomoon-icon-remove del_anx'></span></a>";
                archivo += "</li>";

                $(".galleryView").append(archivo);
                $("#btnFoto").hide();
            } else { //el formato es incorrecto
                crear_alerta('error', 'Archivo Dañado o formato Incorrecto', 'Verifique el archivo nuevamente');
            }
        }});

    $(".eliminar_imagen_foto").live("click", function (event) {
        event.preventDefault();
        url = $(this).attr('custom');
        id_key = this.custom_id;
        id = this.id;

        var ruta = "";//($("#hdnRutaUbicacion").val() != '') ? $("#hdnRutaUbicacion").val() : null;

        $.ajax({
            type: 'POST',
            url: urlj + 'modulo_gestion_documental/procesos/eliminar_imagen_gral/' + carpeta,
            data: {url: url, ruta: ruta},
            success: function (data) {
                $(".galleryView").empty();
                $("#btnFoto").show();
                $("#slcTipo option:selected").removeAttr('selected', 'selected');
                $("#slcTipo").select2();
                $("#txtTamanio").val('');
                $("#hdnTamanio").val(0);
            }
        });
    });

    $(".delete_anexo").live('click', function (event) {
        event.preventDefault();

        var anexo = $(this).data('anexo');

        $("#anexo_" + anexo).remove().delay(500);
    });

    $("#frm-archivo").validate({
        ignore: [],
        rules: {
            txtNombreArchivo: {required: true},
            slcUbicacion: {required: true},
            slcTipo: {required: true},
            txtCreador: {required: true},
            slcCategorias: { required: true },
            slcEtiquetas: { required: true },
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {

            if (!($("#hdnArchivo").length > 0)) {
                crear_alerta('error', 'Avisos', 'Archivo es necesario para guardar.');
                return false;
            }

            form.submit();
        }
    });
    
    $("#txtNombreArchivo, #txtDescripcion").keyup(function(){
       generarKeywork(); 
    });
});

function formatBytes(bytes) {
    if (bytes < 1024)
        return bytes + " Bytes";
    else if (bytes < 1048576)
        return(bytes / 1024).toFixed(3) + " KB";
    else if (bytes < 1073741824)
        return(bytes / 1048576).toFixed(3) + " MB";
    else
        return(bytes / 1073741824).toFixed(3) + " GB";
}

function generarKeywork() {
    var nombreArchivo = $("#txtNombreArchivo").val();
    var descripcion = $("#txtDescripcion").val();

    var keyword = "Nombre:" + nombreArchivo + " Descripcion:" + descripcion;
    $("#txtKeyword").val(keyword);
}
