jQuery(document).ready(function ($) {

$("body").on('click', '.descargar_archivoN', function(event) {
  event.preventDefault();
  url_action = $(this).attr("href");
  alerta_confirm(url_action,"Alerta de confirmación","¿Ésta seguro de elminar el registro seleccionado?")
  });

$("body").on('click', '.deshabilitar_archivo', function(event) {
  event.preventDefault();
  url_action = $(this).attr("href");
  alerta_confirm(url_action,"Alerta de confirmación","¿Ésta seguro de deshabilitar el archivo seleccionado?")
  });
  
  $("body").on('click', '.enviar_link_archivo', function(event) {
    event.preventDefault();
    url_action = $(this).attr("href");
    id_archivo = $(this).attr("id_archivo");
    nombre_archivo = $(this).parents('tr').children('td:first').next().text();
    $("#td_link").val(url_action);
    $("#td_linkLabel").text(nombre_archivo);
    $("#id_archivo_reg").val(id_archivo);
    $("#correo_destino").val('');
    $("#txtComentario").val('');
    $("#mostrar_formulario_modal").trigger('click');
    });

  $("#mostrar_formulario_modal").fancybox({
     openEffect  : 'elastic',
     closeEffect : 'elastic'
   });

  $("body").on('click', '#enviar_link', function(event) {
    event.preventDefault();
    enviar_link_archivo();
    });

  $("body").on('click', '.comentario_archivo', function(event) {
    event.preventDefault();
      $.fancybox({
        'width': '60%',
        'height' : '50%',
        'autoScale': true,
         openEffect  : 'elastic',
         closeEffect : 'elastic',
        'href':  $(this).attr('href'),
        'title': "COMENTARIOS DE ARCHIVO",
        'type': 'iframe'
      });
      
  });

    $('select').select2();

    $("#tbl_search").dataTable();

    $(".filter_date").mask('9999-99-99');
    $(".filter_date").datepicker({dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true});

    $("#txtFecha_creacion, #txtFecha_actualiza").mask('99-99-9999');
    $("#txtFecha_creacion, #txtFecha_actualiza").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {},
        messages: {},
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select')) {
                $(element).next().append(error);
            } else {
                error.insertAfter(element);
            }
        },
        submitHandler: function (form) {

            data_filter();

        }
    });
});



function enviar_link_archivo() {
    url_archivo = $("#td_link").val();
    id_archivo =  $("#id_archivo_reg").val();
    correo_destino = $("#correo_destino").val();
    txtComentario = $("#txtComentario").val();

    if (correo_destino != "" && txtComentario != "" && id_archivo > 0 && url_archivo != "" && isEmail(correo_destino)) 
    {      
      url_ajax = window.satelite.base_url('modulo_gestion_documental/procesos/enviar_link_archivo');
       $.ajax({
           url: url_ajax,
           type: 'POST',
           dataType: 'json',
           data: {
               id_archivo: id_archivo,
               url_archivo: url_archivo,
               correo_destino: correo_destino,
               txtComentario: txtComentario
           },
           beforeSend: function () {
               wait.start();
           },
           error: function (xhr, status, error){
            exportarError(xhr.responseText);
            wait.close();
        },
        success: function (json) {
            wait.close();
            if (json.exito == 1) {
              $.fancybox.close();
              crear_alerta("success","Enviado correctamente","");
              $("#td_link").val("");
              $("#id_archivo_reg").val("");
              $("#correo_destino").val("");
              $("#txtComentario").val("");
            } else {
              $.fancybox.close();
              crear_alerta("error","Problemas al enviar link","Favor intentar más tarde");
              $("#td_link").val("");
              $("#id_archivo_reg").val("");
              $("#correo_destino").val("");
              $("#txtComentario").val("");
            }
        }
    });
  }
  else {
    crear_alerta("error","Error. Verificar:","*El correo y el detalle son requeridos <br /> *Se debe escribir correo valido");
  }
}

function descargar_archivo(url_archivo) {
    if (url_archivo != "") 
    {      
      url_ajax = window.satelite.base_url('modulo_gestion_documental/procesos/descargar_archivo');
       $.ajax({
           url: url_ajax,
           type: 'POST',
           dataType: 'json',
           data: {
               url_archivo: url_archivo
           },
           beforeSend: function () {
               wait.start();
           },
           error: function (xhr, status, error){
            exportarError(xhr.responseText);
            wait.close();
        },
        success: function (json) {
            wait.close();
            if (json.exito == 1) {
              crear_alerta("success","Archivo descargado correctamente","");
            } else {
              crear_alerta("error","Problemas al descargar archivo","Favor intentar más tarde");
            }
        }
    });
  }
}

function isEmail(email) {
  var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
  return regex.test(email);
}



function data_filter() {
    let filtrosMetadata = {};
    $(".filtro-metadata").each(function () {
        let campo = $(this).attr("name");
        let valor = $(this).val();
        if (valor !== "") {
            filtrosMetadata[campo] = valor; // Agregar solo si tiene valor
        }
    });

    let txtFecha_creacion_desde = $("#txtFecha_creacion_desde").val();
    let txtFecha_creacion_hasta = $("#txtFecha_creacion_hasta").val();
    let txtFecha_actualiza_desde = $("#txtFecha_actualiza_desde").val();
    let txtFecha_actualiza_hasta = $("#txtFecha_actualiza_hasta").val();
    let slcCategoria = $("#slcCategoria").val();
    let slcEtiqueta = $("#slcEtiqueta").val();
    let txtNombre = $("#txtNombre").val();
    let slcTipo = $("#slcTipo").val();
    let slcUsuario = $("#slcUsuario").val();
    let txtKeyword = $("#txtKeyword").val();

    // Deshabilitar botón de submit y mostrar overlay
    

    var table = $("#tbl_search").dataTable({
        "sPaginationType": "full_numbers",
        "bFilter": true,
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 5,
        "bLengthChange": true,
        "bDestroy": true,
        "bServerSide": true,
        "aLengthMenu": [[5, 10, 25, 50, 100, 500, 1000, 10000], [5, 10, 25, 50, 100, 500, 1000, 10000]],
        "sAjaxSource": window.satelite.base_url("modulo_gestion_documental/procesos/get_archives"),
        "fnServerData": function (sSource, aoData, fnCallback) {
            $(".search_boxed").append('<div class="_loading-overlay"><div class="_loader2"></div></div>');
            $("#btnConsultar").prop("disabled", true).html('<span class="_loader"></span> Buscando...');

            aoData.push(
                { "name": "txtFecha_creacion_desde", "value": txtFecha_creacion_desde },
                { "name": "txtFecha_creacion_hasta", "value": txtFecha_creacion_hasta },
                { "name": "txtFecha_actualiza_desde", "value": txtFecha_actualiza_desde },
                { "name": "txtFecha_actualiza_hasta", "value": txtFecha_actualiza_hasta },
                { "name": "slcCategoria", "value": slcCategoria },
                { "name": "slcEtiqueta", "value": slcEtiqueta },
                { "name": "txtNombre", "value": txtNombre },
                { "name": "slcTipo", "value": slcTipo },
                { "name": "slcUsuario", "value": slcUsuario },
                { "name": "txtKeyword", "value": txtKeyword },
                { "name": "filtros_metadata", "value": JSON.stringify(filtrosMetadata) }
            );

            $.ajax({
                "dataType": "json",
                "type": "POST",
                "url": sSource,
                "data": aoData,
                "success": function (data) {
                    fnCallback(data);
                },
                "error": function (jqXHR, textStatus, errorThrown) {
                    console.error("Error en AJAX:", textStatus, errorThrown);

                    $(".search_boxed").append('<div class="error-overlay">Error en la carga de datos</div>');
                    setTimeout(function () {
                        $(".error-overlay").fadeOut(300, function () { $(this).remove(); });
                    }, 3000);
                },
                "complete": function () {
                    $("._loading-overlay").fadeOut(300, function () { $(this).remove(); });
                    $("#btnConsultar").prop("disabled", false).html(`<span class="icon16 icomoon-icon-search-3 white"></span> Consultar`);
                }
            });
        },
        "aoColumns": [
            { "mData": "categorias" },
            { "mData": "arh_nombre" },
            { "mData": "mga_campo" },
            {
                "mData": "arh_id",
                "bSortable": true,
                "mRender": function (data, type, row) {
                    let html = `<div class="btn-group">
                        <button class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button>
                        <button class="btn dropdown-toggle" data-toggle="dropdown">
                            <span class="caret"></span>
                        </button>
                        <ul class="dropdown-menu">`;

                    if (row.permisos.descargar == 1) {
                        html += `<li><a class="tip descargar_archivo" title="Descargar" target="_blank"
                                  href="${window.satelite.base_url(row.uba_ruta)}/${row.arh_url_archivo}">
                                  <span class="icomoon-icon-file-download"></span> Descargar</a></li>`;
                    }
                    if (row.permisos.escritura == 1) {
                        html += `<li><a class="tip editar_archivo" title="Ficha" 
                                  href="${window.satelite.base_url('modulo_gestion_documental/procesos/editar_archivo/' + row.arh_id)}">
                                  <span class="icomoon-icon-file-2"></span> Ficha</a></li>`;
                    }
                    if (row.permisos.deshabilitar == 1) {
                        html += `<li><a class="tip deshabilitar_archivo" title="Deshabilitar"
                                  href="${window.satelite.base_url('modulo_gestion_documental/procesos/deshabilitar_archivo/' + row.arh_id)}">
                                  <span class="icomoon-icon-cancel"></span> Deshabilitar</a></li>`;
                    }
                    if (row.permisos.comentario == 1) {
                        html += `<li><a class="tip comentario_archivo" title="Comentarios"
                                  href="${window.satelite.base_url('modulo_gestion_documental/procesos/comentario_archivo/' + row.arh_id)}">
                                  <span class="brocco-icon-list"></span> Comentarios</a></li>`;
                    }
                    if (row.permisos.actualizar == 1) {
                        html += `<li><a class="tip actualizar_archivo" title="Actualizar"
                                  href="javascript: void(0);">
                                  <span class="cut-icon-reload"></span> Actualizar</a></li>`;
                    }
                    if (row.permisos.enviar_vinculo == 1) {
                        html += `<li><a class="tip enviar_link_archivo" title="Enviar vínculo"
                                  href="${window.satelite.base_url(row.uba_ruta)}/${row.arh_url_archivo}">
                                  <span class="icomoon-icon-mail-3"></span> Enviar vínculo</a></li>`;
                    }
                    html += `<li><a class="tip editar_archivo" title="Leer Ficha" 
                              href="${window.satelite.base_url('modulo_gestion_documental/procesos/leer_ficha/' + row.arh_id)}">
                              <span class="icomoon-icon-file-2"></span> Leer Ficha</a></li>`;

                    html += `</ul></div>`;
                    return html;
                }
            }
        ],
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });

}

$('<style>')
    .prop("type", "text/css")
    .html(`
        ._loading-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }
        ._loader {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #3498db;
            border-radius: 50%;
            width: 16px;
            height: 16px;
            animation: spin 1s linear infinite;
            display: inline-block;
            vertical-align: middle;
        }


        ._loader2 {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #3498db;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
            display: inline-block;
            vertical-align: middle;
        }


        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    `)
    .appendTo("head");

 
