let currentPath = {}; 
let breadcrumb = [];
let currentRequest = null;
let selected = [];

// --- UTILIDADES ---
function cleanJSON(res){ res=res.replace(/^\uFEFF/,'').trim(); try{return JSON.parse(res);}catch(e){return null;} }
function addLog(msg,type="ok"){
  const pb=document.getElementById("progressBox");
  pb.style.display="block";
  const step=document.createElement("div");
  step.className="progress-step "+type;
  step.innerHTML=`<i class="fa ${type==='ok'?'fa-check-circle':'fa-times-circle'}"></i> ${msg}`;
  pb.appendChild(step);
  pb.scrollTop=pb.scrollHeight;
}

// --- RENDER BREADCRUMB ---
function renderBreadcrumb(){
  const bc=document.getElementById("breadcrumb"); bc.innerHTML="";
  breadcrumb.forEach((b,i)=>{
    const span=document.createElement("span");
    span.className="crumb"+(i===breadcrumb.length-1?" active":"");
    span.textContent=b.label;
    if(i<breadcrumb.length-1){
      span.addEventListener("click",()=>{breadcrumb=breadcrumb.slice(0,i+1); currentPath={...breadcrumb[i].filters}; loadData();});
    }
    bc.appendChild(span);
    if(i<breadcrumb.length-1) bc.innerHTML+=" / ";
  });
}

// --- CARGA DE DATOS ---
function loadData(page=1,search=""){
  const cont=document.getElementById("lista-docs");
  cont.classList.remove("fade-in");
  selected=[]; toggleBtn();
  if(currentRequest) currentRequest.abort();
  currentRequest=$.ajax({
    type:"POST",
    url: URL_GET,
    data:{...currentPath,page,search},
    success:(res)=>{
      const data=cleanJSON(res);
      if(!data) return;
      renderFromDB(data);

      if (data.ruta && data.ruta.length > 0) {
        breadcrumb = data.ruta;
        renderBreadcrumb();
      }


      renderPagination(data);
      cont.classList.add("fade-in");
    },
    complete:()=>{currentRequest=null;}
  });
}


function renderFromDB(resp) {
  renderBreadcrumb();
  const cont = document.getElementById("lista-docs");
  cont.innerHTML = "";
  document.getElementById("pagination").style.display = (resp.nivel === "archivos" && resp.pages > 0) ? "flex" : "none";

  if (!resp.data || resp.data.length === 0) {
    cont.innerHTML = "<p style='padding:10px 20px;'>No hay resultados.</p>";
    return;
  }

  if (resp.nivel === "archivos") {
    resp.data.forEach(item => {
      const ruta = baseRuta + item.ruta_file;
      const card = document.createElement("div");
      card.className = "pdf-card";

      // Detectar tipo
      const esPDF = (item.tipo === "pdf" || (item.archivo && item.archivo.toLowerCase().endsWith(".pdf")));
      const icono = '<i class="fas fa-file-invoice" style="font-size:48px;color:#0069B1;"></i>';

      card.innerHTML = `
        <div class="file-icon">${icono}</div>
        <div class="pdf-info">
          <div class="title">${item.archivo}</div>
          <p><small><b>TIPO </b>${item.tipo_nombre || item.tipo}</small></p>
          <p><small><b>Cliente </b>${item.cliente}</small></p>
          <p><small><b>POR $</b>${item.fac_total}</small></p>
        </div>
        <div class="pdf-actions">
           <a href="${ruta}.pdf" download><button><i class="fa fa-file-pdf"></i> PDF</button></a>
           <a href="${ruta}.json" download><button><i class="fa fa-code"></i> JSON</button></a>
           <a href="${ruta}.pdf" class='verPdfFactura'><button><i class="fa fa-eye"></i> Ver</button></a>
         </div>`;
      cont.appendChild(card);
    });
  } else {
    const isTipoLevel = resp.nivel === "tipos";
    resp.data.forEach(d => {
      const label = isTipoLevel ? d.tipo_nombre : Object.values(d)[0];
      const value = isTipoLevel ? d.tipo_abrev : Object.values(d)[0];
      const card = document.createElement("div");
      card.className = "folder-card";
      card.innerHTML = `
        <input type="checkbox" class="check-select">
        <i class="fa fa-folder"></i>
        <span>${label}</span>`;
      setCardSelect(card, value);
      card.addEventListener("click", e => {
        if (e.target.classList.contains("check-select")) return;
        document.querySelectorAll(".folder-card").forEach(f => f.classList.remove("loading"));
        card.classList.add("loading");
        const nf = { ...currentPath };
        if (resp.nivel === "anios") nf.anio = value;
        else if (resp.nivel === "meses") nf.mes = value;
        else if (resp.nivel === "dias") nf.dia = value;
        else if (resp.nivel === "tipos") nf.tipo = value;
        breadcrumb.push({ label, filters: nf });
        currentPath = nf;
        loadData();
      });
      cont.appendChild(card);
    });
  }
}

$(document).on("click",".verPdfFactura", function() {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            autoSize: false,
            width: '90%',
            height: $(window).height() * 0.9,
            fitToView: false,
            closeBtn: true,
        }); 
    });



// --- PAGINACIÓN ---
function renderPagination(resp) {
  const pag = document.getElementById("pagination");
  pag.innerHTML = "";
  if (!resp.pages || resp.pages < 1) return;

  const prev = document.createElement("button");
  prev.textContent = "« Anterior";
  prev.disabled = resp.page <= 1;
  prev.addEventListener("click", () => loadData(resp.page - 1));
  pag.appendChild(prev);

  const start = Math.max(1, resp.page - 2);
  const end = Math.min(resp.pages, start + 4);
  for (let i = start; i <= end; i++) {
    const btn = document.createElement("button");
    btn.textContent = i;
    if (i === resp.page) btn.classList.add("active");
    btn.addEventListener("click", () => loadData(i));
    pag.appendChild(btn);
  }

  const next = document.createElement("button");
  next.textContent = "Siguiente »";
  next.disabled = resp.page >= resp.pages;
  next.addEventListener("click", () => loadData(resp.page + 1));
  pag.appendChild(next);

  const info = document.createElement("span");
  info.className = "info";
  info.textContent = `Mostrando ${resp.total} registro${resp.total !== 1 ? 's' : ''}`;
  pag.appendChild(info);
}

// --- SELECCIÓN Y BOTONES ---
function setCardSelect(card,id){
  const chk=card.querySelector(".check-select");
  chk.addEventListener("change",()=>{ 
    if(chk.checked){ card.classList.add("card-selected"); selected.push(id);} 
    else{ card.classList.remove("card-selected"); selected=selected.filter(v=>v!==id);} 
    toggleBtn(); 
  });
}

function toggleBtn(){
  const btn=document.getElementById("btnDownloadMulti");
  btn.style.display=selected.length>0?"inline-block":"none";
  btn.textContent=`Descargar (${selected.length}) seleccionados`;
}

// --- EVENTO: DESCARGAR SELECCIONADOS ---
document.getElementById("btnDownloadMulti").addEventListener("click",()=> {
  if(selected.length===0)return;
  const pb=document.getElementById("progressBox");
  pb.innerHTML=""; pb.style.display="block";
  addLog("Verificando carpetas...");
  document.querySelectorAll(".card-selected").forEach(c=>c.classList.add("loading"));

  $.post(URL_DES,
    { items: JSON.stringify(selected), path: JSON.stringify(currentPath) },
    function(res){
      if(res.status==="ok"){
        addLog("Comprobando estructuras...");
        setTimeout(()=>addLog("Comprimiendo archivos..."),800);
        setTimeout(()=>addLog("Descargando ZIP..."),1600);
        setTimeout(()=>{
          window.location = res.zip;
          addLog("✅ Descarga completada","ok");
          document.querySelectorAll(".folder-card").forEach(c=>c.classList.remove("loading"));
          setTimeout(()=>pb.style.display="none",5000);
        },2500);
      }else{
        addLog("❌ "+res.msg,"err");
        if(res.log) addLog(res.log,"err");
        document.querySelectorAll(".folder-card").forEach(c=>c.classList.remove("loading"));
      }
    },"json"
  ).fail(() => {
    addLog("❌ Error en la solicitud al servidor.", "err");
    document.querySelectorAll(".folder-card").forEach(c => c.classList.remove("loading"));
  });
});

// --- SUBIR NIVEL ---
document.getElementById("btnUp").addEventListener("click",()=>{ 
  if(breadcrumb.length>1){breadcrumb.pop();currentPath={...breadcrumb[breadcrumb.length-1].filters};loadData();}
  else{let f=document.querySelector(".sucursal.active");if(f)f.click();}
});

// --- EVENTO SUCURSAL ---
document.querySelectorAll(".sucursal").forEach(btn=>{ 
  btn.addEventListener("click",()=>{ 
    document.querySelectorAll(".sucursal").forEach(b=>b.classList.remove("active")); 
    btn.classList.add("active"); 
    const codigo=btn.getAttribute("data-suc-codigo"); 
    const nombre=btn.getAttribute("data-sucursal"); 
    currentPath={suc_codigo:codigo,sucursal:nombre}; 
    breadcrumb=[{label:nombre,filters:currentPath}]; 
    loadData(); 
  }); 
});

document.addEventListener("DOMContentLoaded",()=>{ 
  let f=document.querySelector(".sucursal"); 
  if(f)f.click(); 
});

// --- EVENTO: BUSCAR ---
document.getElementById("btnSearch").addEventListener("click", () => {
  const term = document.getElementById("globalSearch").value.trim();
  loadData(1, term);
});

// Permitir buscar presionando Enter
document.getElementById("globalSearch").addEventListener("keypress", (e) => {
  if (e.key === "Enter") {
    e.preventDefault();
    document.getElementById("btnSearch").click();
  }
});