$(document).ready(function () {
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');
    $('select').select2({placeholder: 'Seleccione una opción'});


    $("#frm-permisos").validate({
        ignore: [],
        rules: {

        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {

            // var fechaDesde = $("#txtFechaDesde").val();
            // var fechaHasta = $("#txtFechaHasta").val();

            // if (!validarPeriodo(fechaDesde, fechaHasta)) {
            //     crear_alerta('error', 'Avisos', 'Verifique el período de las fechas.');
            //     return false;
            // }

            if ($(".trPermiso").length == 0) {
                crear_alerta('error', 'Permisos Categoria', 'Debe ingresar al menos un permiso.');
                return false;
            }
            form.submit();
        }
    });

    $("#slcRoles").change(function () {
        var estadoSelect = ($(this).val() != '') ? 'disable' : 'enable';
        $("#slcUsuarios").select2(estadoSelect);
    });

    $("#slcUsuarios").change(function () {
        var estadoSelect = ($(this).val() != '') ? 'disable' : 'enable';
        $("#slcRoles").select2(estadoSelect);
    });

    $("#btnAgregar").click(function () {
        var slcRol = $("#slcRoles").val();
        var slcRolText = ($("#slcRoles option:selected").text()).trim();
        var slcUsuario = $("#slcUsuarios").val();
        var slcUsuarioText = ($("#slcUsuarios option:selected").text()).trim();
        var slcPermisos = $("#slcPermisos").val();

        if (slcRol == '' && slcUsuario == '') {
            crear_alerta('error', 'Permisos', 'Debe seleccionar al menos un Rol/Usuario.');
            return false;
        }

        if (slcPermisos == '' || slcPermisos == null) {
            crear_alerta('error', 'Permisos', 'Debe seleccionar al menos un permiso.');
            return false;
        }


        if(slcRol!=''){
            if($("#tr_rol_" + slcRol).length>0){
                crear_alerta('error', 'Permisos', 'El Rol ya fue agregado.');
                return false;       
            }
        }

        if(slcUsuario!=''){
            if($("#tr_usu_" + slcUsuario).length>0){
                crear_alerta('error', 'Permisos', 'El Usuario ya fue agregado.');
                return false;       
            }
        }

//        else{
//            if($("#tr_")){
//                
//            }
//        }

        var slcPermisosText = "";
        var contadorOpciones = $('#slcPermisos option:selected').length;
        var contador = 1;
        $('#slcPermisos option:selected').each(function () {
            slcPermisosText += (contador == contadorOpciones) ? $(this).text() : $(this).text() + ',';
            contador++;
        });

        var codigoTr = (slcRol != '') ? "rol_" + slcRol : "usu_" + slcUsuario;
        var tipoCombo = (slcRol != '') ? 1 : 2;
        var textoCombo = (slcRol != '') ? slcRolText : slcUsuarioText;

        var trHtml = '';

        trHtml += '<tr id="tr_' + codigoTr + '" class="trPermiso">';
        trHtml += '<td>';
        trHtml += '<input type="hidden" name="hdnPermisos[]" value="' + slcPermisos + '" />';
        trHtml += '<input type="hidden" name="hdnComboRol[]" value="' + slcRol + '" />';
        trHtml += '<input type="hidden" name="hdnComboUsuario[]" value="' + slcUsuario + '" />';
        trHtml += textoCombo;
        trHtml += '</td>';
        trHtml += '<td>' + slcPermisosText + '</td>';
        trHtml += '<td>';
        trHtml += '<div class="tools">';
        trHtml += ' <div class="btn-group"><button class="btn" type="button"><span class="icon16 icomoon-icon-cog-2"></span></button><button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button>';
        trHtml += '<ul class="dropdown-menu">';
        trHtml += '<li>';
        trHtml += '  <a href="#" id="btnEliminar_' + codigoTr + '" data-id="' + codigoTr + '"  title="Eliminar" class="btnDelFila"><span class="icon16 icomoon-icon-cancel-4" title="eliminar"></span>Eliminar</a>';
        trHtml += '</li>';
        trHtml += '</ul>';
        trHtml += '</div>';
        trHtml += '</div>';
        trHtml += '</td>';
        trHtml += '</tr>';


        var oTable = $('#tblPermisos').dataTable();
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tblPermisos").append(trHtml);
        aplicarDataTable('#tblPermisos');

        $("#slcRoles option:selected").removeAttr('selected');
        $("#slcRoles").select2({placeholder: "Seleccione una opción"});
        $("#slcUsuarios option:selected").removeAttr('selected');
        $("#slcUsuarios").select2({placeholder: "Seleccione una opción"});
        $("#slcPermisos option:selected").removeAttr('selected');
        $("#slcPermisos").select2({placeholder: "Seleccione una opción"});
    });

    $("body").on('click', '.btnDelFila', function () {
        var idTr = $(this).attr('data-id');

        var parent = $("#tr_" + idTr);

        var oTable = $('#tblPermisos').dataTable();

        oTable.fnDeleteRow(parent[0]);
    });
});

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": true,
        "bInfo": false,
        "bSort": false,
        "bLengthChange": false,
        "bFilter": false
    });
    $(idTabla).css('width', '100%');
}