jQuery(document).ready(function ($) {
    $('select').select2();
    $("#txtFecha_desde, #txtFecha_hasta").mask('99-99-9999');
    $("#txtFecha_desde, #txtFecha_hasta").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
    $("#txtFecha_desde, #txtFecha_hasta").change(function(event) {  validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta'); });

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            txtFecha_desde: {required: true},
            txtFecha_hasta: {required: true}
        },
        messages: {
            txtFecha_desde: "Campo requerido",
            txtFecha_hasta: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }
            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");

        },
        submitHandler: function (form) {
           $("#contenedorTabla").hide("slide", { 
            direction: 'right'
          }, 400, function() { //despues de ocultar div enviar el ajax

              url_ajax = window.satelite.base_url('modulo_eventos/procesos/filtrar_evento');
               $.ajax({
                   url: url_ajax,
                   type: 'POST',
                   dataType: 'json',
                   data: {
                       txtFecha_desde: $("#txtFecha_desde").val(),
                       txtFecha_hasta: $("#txtFecha_hasta").val()
                   },
                   beforeSend: function () {
                       wait.start();
                   },
                   error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $("#contenedorTabla").html(json.html);
                    $("#contenedorTabla").show("slide", {
                      direction: 'left'
                    }, 500);
                    wait.close();

                }
            });
        });
       }
   });

//visualizar_evento();
$("body").on('click', '.eliminar_evento', function(event) {
  event.preventDefault();
  url_action = $(this).attr("href");
  alerta_confirm(url_action,"Alerta de confirmación","¿Ésta seguro de elminar el registro seleccionado?")
  });

  $("body").on('click', '.ver_evento', function(event) {
    event.preventDefault();
      $.fancybox({
        'width': '90%',
        'height' : '80%',
        'autoScale': true,
         openEffect  : 'elastic',
         closeEffect : 'elastic',
        'href':  $(this).attr('href'),
        'title': "DETALLE DE EVENTO",
        'type': 'iframe'
      });
      //visualizar_evento(); //cargar el fancybox
  });

  $("body").on('click', '.recodatorio_evento', function(event) {
    event.preventDefault();
    url_action = $(this).attr("href");
    id_evento = $(this).attr("id_evento");
    alerta_confirm_ajax(recordatorio_evento,id_evento,"Alerta de confirmación","¿Enviar recortorio de evento?")
    });

});

function visualizar_evento() {
  $(".ver_evento").fancybox({
     openEffect  : 'elastic',
     closeEffect : 'elastic',
     href: $(this).attr('href'),
     type: 'iframe'
   });
}

function recordatorio_evento(id_evento) {
    if (id_evento > 0) 
    {      
      url_ajax = window.satelite.base_url('modulo_eventos/procesos/recordatorio_evento');
       $.ajax({
           url: url_ajax,
           type: 'POST',
           dataType: 'json',
           data: {
               id_evento: id_evento
           },
           beforeSend: function () {
               wait.start("Espere unos segundos... enviando recortorio");
           },
           error: function (xhr, status, error){
            exportarError(xhr.responseText);
            wait.close();
        },
        success: function (json) {
            wait.close();
            if (json.exito == 1) {
              crear_alerta("success","Recordatorio enviado con éxito","");
            } else {
              crear_alerta("error","Recordatorio no enviado","Favor intentar más tarde");
            }
        }
    });
  }
}
