jQuery(document).ready(function ($) {

    $('select').select2();
    $("#form_editar").validate({
        ignore: "",
        rules: {
            nombre: { required: true},
            orden: { required: true},
            categoria: {required: true, min:1},
            tipo_competencia: {required: true, min:1},
            numero_detalles: {required: true, min:2}
        },
        messages: {
            nombre: "Campo requerido",
            orden: "Campo requerido",
            categoria: "Campo requerido",
            tipo_competencia: "Campo requerido",
            numero_detalles: "Campo requerido, con al menos dos opciones"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }
        },
        submitHandler: function (form) {
           form.submit();
       }
   });
    
    $("#ponderacion").change(function(event) {
      peso = ($(this).val() > 0 )? $("#ponderacion option:selected").attr('peso'):'';
      $("#peso").val(peso);
    });


    $("#agregar").click(function(event) {
        event.preventDefault();
        tr = '';
        if ($("#peso").val().trim()!='' && $("#ponderacion").val() > 0 ) {
            
            if ($("#pon_"+$("#ponderacion").val().trim()).length>0) {
                crear_alerta('error', 'Error', 'La ponderación ya existe');
            } else {

            tr += '<tr id="pon_'+$("#ponderacion").val().trim()+'" ><td style="text-align: center;" ><input type="hidden" value="'+$("#ponderacion").val().trim()+'" name="detalle_pon[]" >';
            tr += $("#ponderacion option:selected").text().trim() + '</td>';
            tr += '<td style="text-align: center;" ><input type="hidden" value="'+$("#peso").val().trim()+'" name="detalle_peso[]" >'+$("#peso").val().trim()+'</td>';
            tr += '<td style="text-align: center;" >';
            tr += '<button  type="button"  class="tip eliminar_detalle" oldtitle="Eliminar" title="Eliminar" >';
            tr += '<span class="icon16 icomoon-icon-cancel-3"></span> Eliminar';
            tr += '</button>';
            $("#contenedor_detalle_opciones").append(tr);
            //$("#respuesta").val('');
            $("#numero_detalles").val($("#contenedor_detalle_opciones tr").length);
            }

        } else {
            crear_alerta('error', 'Error', 'La ponderación es obligatoria');
        }
    });

    $("#tipo_competencia").click(function(event) {
        event.preventDefault();
        if($(this).val()==2) {
            $("#contenedor_detalle_opciones").html('');
            $("#numero_detalles").val('');
            $("#detalle_opciones").show('slow');
        } else {
            $("#detalle_opciones").hide('slow');
            $("#contenedor_detalle_opciones").html('');
            $("#numero_detalles").val('2');
        }
    });


    $(".eliminar_detalle").live('click', function(event) {
        $(this).parent().parent().remove(); //eliminar el detalle
        $("#numero_detalles").val($("#contenedor_detalle_opciones tr").length);

    });

    //Validaciones
    $("#orden").blur(function(event) { validar_orden();  });
    $("#nombre").blur(function(event) { validar_competencia();  });
    $("#guardar, #guardar_volver").mouseover(function(event) { validar_orden(); validar_competencia(); });

});


function validar_orden() {
    if($("#orden").val()>0) {
           $.ajax({
               url:window.satelite.base_url('modulo_evaluacion_desempeno/procesos/validar_orden'),
               type: 'POST',
               dataType: 'json',
               data: {
                   orden: $("#orden").val(),
                   id_eva: $("#id_evaluacion").val(),
                   id_competencia: $("#id_competencia").val()
               },
               beforeSend: function () {
                   //wait.start();
               },
               error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                if(json.existe==1) {
                    $("#orden").val('');
                    crear_alerta('error','Existe','El número de competencia ya existe');
                }

            }
        });
    }
}

function validar_competencia() {
    if($("#nombre").val().trim()!='') {
           $.ajax({
               url:window.satelite.base_url('modulo_evaluacion_desempeno/procesos/validar_competencia'),
               type: 'POST',
               dataType: 'json',
               data: {
                   competencia: $("#nombre").val(),
                   id_eva: $("#id_evaluacion").val(),
                   id_competencia: $("#id_competencia").val()
               },
               beforeSend: function () {
                   //wait.start();
               },
               error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                if(json.existe==1) {
                    $("#nombre").val('');
                    crear_alerta('error','Existe','La competencia ya existe para dicha evaluación');
                }

            }
        });
    }
}