jQuery(document).ready(function ($) {
	
    $('select').select2();

    $("#form_agregar").validate({
        ignore: "",
        rules: {
            periodo: {required: true, min:1},
            empleado: {required: true, min:1},
            evaluacion_puesto: {required: true, min:1},
            total_calificacion: {required: true, min:0.00000001}
        },
        messages: {
            periodo: "Campo requerido",
            empleado: "Campo requerido",
            evaluacion_puesto: "Campo requerido",
            total_calificacion: "Calificación requerida"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select')){
                $(element).next().append(error);
            }else{
                error.insertAfter(element);
            }
        },
        submitHandler: function (form) {
            wait.start();
            $("#empleado").select2("destroy");
            $("#empleado").attr("disabled", false);
            $("#empleado").select2({ placeholder: "Seleccione" });
            var vacias = 0;
            $('.contestar').each(function(){
                vacias += ($.trim($(this).val()) != "") ? 0 : 1;
            });
            if (vacias > 0) {
                crear_alerta('error', 'Evaluación', 'Debe evaluar todas las competencias.');
                wait.close();
            } else {
                form.submit();
            }
        }
    });
    
    $("#empleado").change(function(event) {
      plaza = ($(this).val() > 0 )? "Plaza: <b>"+$("#empleado option:selected").attr('plz')+"</b>":'';
      $("#plaza_empleado").html(plaza);
      cargar_evaluacion();
      setTimeout(function() { validar_evaluacion_empleado(); }, 1000);
  });


    $("#agregar").click(function(event) {
        event.preventDefault();
        tr = '';
        if ($("#peso").val().trim()!='' && $("#ponderacion").val() > 0 ) {            
            if ($("#pon_"+$("#ponderacion").val().trim()).length>0) {
                crear_alerta('error', 'Error', 'La ponderación ya existe');
            } else {
                tr += '<tr id="pon_'+$("#ponderacion").val().trim()+'" ><td style="text-align: center;" ><input type="hidden" value="'+$("#ponderacion").val().trim()+'" name="detalle_pon[]" >';
                tr += $("#ponderacion option:selected").text().trim() + '</td>';
                tr += '<td style="text-align: center;" ><input type="hidden" value="'+$("#peso").val().trim()+'" name="detalle_peso[]" >'+$("#peso").val().trim()+'</td>';
                tr += '<td style="text-align: center;" >';
                tr += '<button  type="button"  class="tip eliminar_detalle" oldtitle="Eliminar" title="Eliminar" >';
                tr += '<span class="icon16 icomoon-icon-cancel-3"></span> Eliminar';
                tr += '</button>';
                $("#contenedor_detalle_opciones").append(tr);
                //$("#respuesta").val('');
                $("#numero_detalles").val($("#contenedor_detalle_opciones tr").length);
            }
        } else {
            crear_alerta('error', 'Error', 'La ponderación es obligatoria');
        }
    });

    $("#tipo_competencia").click(function(event) {
        event.preventDefault();
        if($(this).val()==2) {
            $("#contenedor_detalle_opciones").html('');
            $("#numero_detalles").val('');
            $("#detalle_opciones").show('slow');
        } else {
            $("#detalle_opciones").hide('slow');
            $("#contenedor_detalle_opciones").html('');
            $("#numero_detalles").val('2');
        }
    });

    $(".eliminar_detalle").live('click', function(event) {
        $(this).parent().parent().remove(); //eliminar el detalle
        $("#numero_detalles").val($("#contenedor_detalle_opciones tr").length);
    });

    $("#evaluacion_puesto").change(function(event) {
        cargar_datos_evaluacion();
        setTimeout(function() { validar_evaluacion_empleado(); }, 1000);
    });

    $("#periodo").change(function(event) {
        validar_evaluacion_empleado();
        setTimeout(function() {  $("#empleado").trigger('change'); }, 100);
    });

    $("#anexos").click(function (event) {
        event.preventDefault();
        var url = $(this).attr("href");
        var tipo = url.split("/").pop().split(".")[1];
        console.log(tipo);
        if (tipo == "jpg" || tipo == "png" || tipo == "pdf") {
            $.fancybox({
                'href': url,
                width: '100%',
                openEffect: 'elastic',
                closeEffect: 'elastic',
                type: 'iframe'
            });
            return false;
        } 
        window.open(url);
    });

    // //Validaciones
    // $("#orden").blur(function(event) { validar_orden();  });
    // $("#nombre").blur(function(event) { validar_competencia();  });
     $("#guardar, #guardar_volver").mouseover(function(event) { validar_evaluacion_empleado(); });

}); //fin del document ready

function cargar_evaluacion() {
    if($("#empleado").val()>0) {
    	puesto = ($("#empleado").val() > 0 )? $("#empleado option:selected").attr('puesto'):'0';
        $.ajax({
            url:window.satelite.base_url('modulo_evaluacion_desempeno/procesos/cargar_evaluacion'),
            type: 'POST',
            dataType: 'json',
            data: {
                puesto: puesto,
                id_emp: $("#empleado").val(),
                periodo: $("#periodo").val()
            },
            beforeSend: function () {
                wait.start("Cargando datos evaluación.... Espere unos segundos");
            },
            error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                wait.close();
                if(json.existe==1) {
                    $("#evaluacion_puesto").html(json.html_opc);
                    $("#div_evaluacion").show();
                    $("#evaluacion_puesto").select2();
                    $("#evaluacion_puesto").trigger('change');
                    if ($("#evaluacion_puesto").val() > 0 ) { //si ya viene una opción preseleccionada ocultar el select
                        $("#div_evaluacion").hide();
                    }
                } else {
                    crear_alerta('error','Existe','El puesto asociado a la plaza no posee evaluación asignada');
                    $("#evaluacion_puesto").html('<option value=""></option>');
                    $("#div_evaluacion").hide();
                    $("#evaluacion_puesto").select2();
                    $("#evaluacion_puesto").trigger('change');
                }
            }
        });
    } else {
        $("#evaluacion_puesto").html('<option value=""></option>');
        $("#div_evaluacion").hide();
        $("#evaluacion_puesto").select2();
        $("#evaluacion_puesto").trigger('change');
    }
}

function cargar_datos_evaluacion() {
    $("#nombre_eva").text('');  
    $("#id_evaluacion_puesto").val('0');
    if($("#empleado").val()>0 && $("#evaluacion_puesto").val()>0 ) {
        evaluacion = $("#evaluacion_puesto").val();
        id_ext = $("#evaluacion_puesto option:selected").attr('id_ext');
        $("#id_evaluacion_puesto").val(id_ext);       
        $.ajax({
            url:window.satelite.base_url('modulo_evaluacion_desempeno/procesos/cargar_datos_evaluacion'),
            type: 'POST',
            dataType: 'json',
            data: {
                evaluacion: evaluacion,
                id_emp: $("#empleado").val(),
                periodo: $("#periodo").val()
            },
            beforeSend: function () {
                wait.start("Cargando datos evaluación.... Espere unos segundos");
            },
            error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                wait.close();
                var validar = 0;
                $("#nombre_eva").text(': '+$("#evaluacion_puesto option:selected").text());
                $("#div_tabla_evaluacion").html(json.html_evaluacion);
                $("#div_tabla_evaluacion select").select2();
                $("#muestra_resultado").show();
                $("#nota_eva").text('');
                $("#total_calificacion").val('');
                if (json.info_datos["indicaciones"] != null) {
                    $("#indicaciones").val(json.info_datos["indicaciones"]);
                    $("#label_indic").show();
                    validar++;
                } else {
                    $("#indicaciones").val('');
                    $("#label_indic").hide();
                }

                if (json.info_datos["objetivo"] != null) {
                    $("#Observacion").val(json.info_datos["objetivo"]);
                    $("#label_obser").show();
                    validar++;
                } else {
                    $("#Observacion").val('');
                    $("#label_obser").hide();
                }
                if (json.info_datos["anexo"] != null) {
                    $("#anexos").text(json.info_datos["anexo"]);
                    $("#anexos").attr("href", window.satelite.base_url("uploads/anx_evaluacion/" + json.info_datos["anexo"]));
                    $("#label_anx").show();
                    validar++;
                } else {
                    $("#anexos").text('');
                    $("#anexos").attr("href", "");
                    $("#label_anx").hide();
                }
                if (validar > 0) {
                    $("#nombre_eva2").text(': ' + $("#evaluacion_puesto option:selected").text());
                    $("#informacion").show();
                } else {
                    $("#nombre_eva2").text();
                    $("#informacion").hide();
                }                
            }
        });
    } else {
        $("#div_tabla_evaluacion").html('');
        $("#muestra_resultado").hide();
        $("#nota_eva").text('');
        $("#total_calificacion").val('');
        $("#informacion").hide();
    }
}

function calcular_nota() {
    nota = 0;
    $('.input_resultado').each(function(){
        valor = ($(this).val()>0)? $(this).val():0;
        nota = parseFloat(nota) + parseFloat(valor);
    });
    nota = nota.toFixed(2);
    $("#nota_eva").text(nota);
    $("#total_calificacion").val(nota);
    $("#total_calificacion").trigger('blur');
}


function validar_evaluacion_empleado() {
    if($("#empleado").val()>0) {
        puesto = ($("#empleado").val() > 0 )? $("#empleado option:selected").attr('puesto'):'0';
        $.ajax({
            url:window.satelite.base_url('modulo_evaluacion_desempeno/procesos/validar_evaluacion_empleado'),
            type: 'POST',
            dataType: 'json',
            data: {
                puesto: puesto,
                id_emp: $("#empleado").val(),
                periodo: $("#periodo").val(),
                evaluacion: $("#evaluacion_puesto").val()
            },
            beforeSend: function () {
                //wait.start("Validando Empleado-Evaluación.... Espere unos segundos");
            },
            error: function (xhr, status, error){
                exportarError(xhr.responseText);
                //wait.close();
            },
            success: function (json) {
                // wait.close();
                if(json.existe==1) {
                    crear_alerta('error','Existe','Personal ya ha realizado la evaluación en el periodo seleccionado');
                    $("#evaluacion_puesto").val('');
                    $("#evaluacion_puesto").select2("destroy");
                    //$("#div_evaluacion").hide();
                    $("#evaluacion_puesto").select2({placeholder:"Seleccione"});
                    $("#evaluacion_puesto").trigger('change');
                }
            }
        });
    } 
}
