$(document).ready(function () {
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $("#frm-reporte").validate({
        rules: {
            slcProveedor: {required: true},
            txtFechaIni: {required: true},
            txtFechaFin: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error', 'Campos necesarios', 'Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form) {
            if (!validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val())) {
                crear_alerta('error', 'Filtros', 'Verifique el período de las fechas.');
                return false;
            }
            $("#filtro_inicio").val($("#txtFechaIni").val());
            $("#filtro_fin").val($("#txtFechaFin").val());

            form.submit();
        }
    });

    $("#slcProveedor").select2({
        placeholder: "Buscar Proveedor",
        minimumInputLength: 3,
        multiple: true,
        ajax: {
            url: urlj + 'modulo_cuentas_pagar/procesos/get_proveedores',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (proveedor) {
                return {
                    proveedor: proveedor
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.proveedor,
                        'text': item.nombre_proveedor
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');
    $(".datePicker").blur(function() {
        let value = $(this).val();
        let format = $(this).datepicker('option', 'dateFormat');
        let invalid = true;
        try {
            $.datepicker.parseDate(format, value);
            invalid = false;
        } catch (e) {}
        if (invalid) {
            crear_alerta('info', 'Atención', 'El valor ingresado no es una fecha válida');
            $(this).val('');
        }
    });

    /*Busqueda*/
    $("#btnConsultar").click(function () {

        var proveedor = ($("#slcProveedor").val().length > 0) ? $("#slcProveedor").val() : "";
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        
        if (fecha_ini == '' || fecha_fin == '') {
        //if (fecha_ini == '' || fecha_fin == '' || proveedor == '') {
            crear_alerta('error', 'Filtros', 'Verifique los filtros de búsqueda.');
            return false;
        }

        if (!validarPeriodo(fecha_ini, fecha_fin)) {
            crear_alerta('error', 'Filtros', 'Verifique el período de las fechas.');
            return false;
        }

        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('modulo_cuentas_pagar/reportes/reporte_pagos/1'),
                        data: {proveedor: proveedor, fecha_ini: fecha_ini, fecha_fin: fecha_fin},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                            $(".print").show();
                            var proveedor = ($("#slcProveedor").val().length > 0) ? $("#slcProveedor").val() : "";
                            var fecha_ini = $("#txtFechaIni").val();
                            var fecha_fin = $("#txtFechaFin").val();

                            $("#filtro_proveedor").val(proveedor);
                            $("#filtro_inicio").val(fecha_ini);
                            $("#filtro_fin").val(fecha_fin);

                            $("#filtro_proveedor").val(proveedor);
                            var oTable = $('#tblListado').dataTable();
                            oTable.fnDestroy();
                            console.log(result);
                            $("#tbContenedorListado").html(result);
                            aplidarDataTable('tblListado');

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);
                        }
                    });
                }
        );
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,        
        "bSort": false,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}