$(document).ready(function () {
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });      
    $(".datePicker").mask('99-99-9999');
    $(".datePicker").blur(function() {
        let value = $(this).val();
        let format = $(this).datepicker('option', 'dateFormat');
        let invalid = true;
        try {
            $.datepicker.parseDate(format, value);
            invalid = false;
        } catch (e) {}
        if (invalid) {
            crear_alerta('info', 'Atención', 'El valor ingresado no es una fecha válida');
            $(this).val('');
        }
    });
    /*Busqueda*/
    $("#btnConsultar").click(function () {

        var proveedor = ($("#slcProveedor").val() > 0) ? $("#slcProveedor").val() : "";
        var txtFechaIni = ($("#txtFechaIni").val() != "") ? $("#txtFechaIni").val() : "";
        var txtFechaFin = ($("#txtFechaFin").val() != "") ? $("#txtFechaFin").val() : "";        

        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('modulo_cuentas_pagar/reportes/reporte_cuentas_pagar_resumen/1'),
                        data: {proveedor: proveedor, txtFechaIni:txtFechaIni, txtFechaFin:txtFechaFin},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                            $(".print").show();
                            var proveedor = ($("#slcProveedor").val() > 0) ? $("#slcProveedor").val() : "";

                            $("#filtro_proveedor").val(proveedor);
                            $("#filtro_txtFechaIni").val(txtFechaIni);
                            $("#filtro_txtFechaFin").val(txtFechaFin);
                            var oTable = $('#tblListado').dataTable();
                            oTable.fnDestroy();

                            $("#tbContenedorListado").html(result);
                            aplidarDataTable('tblListado');

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);

                        }
                    });
                }
        );
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}