$(document).ready(function () {
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        closeText: 'Seleccionar',
        currentText: 'Hoy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior"
    });
    $(".datePicker").mask('99-99-9999');
    $(".datePicker").blur(function() {
        let value = $(this).val();
        let format = $(this).datepicker('option', 'dateFormat');
        let invalid = true;
        try {
            $.datepicker.parseDate(format, value);
            invalid = false;
        } catch (e) {}
        if (invalid) {
            crear_alerta('info', 'Atención', 'El valor ingresado no es una fecha válida');
            $(this).val('');
        }
    });
    
    /*Busqueda*/
    $("#btnConsultar").click(function () {
        $(".print").hide();
        var proveedor = ($("#slcProveedor").val() > 0) ? $("#slcProveedor").val() : "";
        var fecha_ini = $("#fecha_ini").val();
        var fecha_fin = $("#fecha_fin").val();
        if (fecha_ini != "" && fecha_fin != "") {
            if (!(verifica_fecha(fecha_ini, fecha_fin))) {
                return false;
            }
        }        
        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
        400, function () {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('modulo_cuentas_pagar/reportes/reporte_cuentas_pagar_detallado/1'),
                data: {
                    proveedor: proveedor,
                    fecha_ini: fecha_ini,
                    fecha_fin: fecha_fin
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    $(".print").show();
                    // var proveedor = ($("#slcProveedor").val() > 0) ? $("#slcProveedor").val() : "";
                    $("#filtro_proveedor").val(proveedor);
                    $("#filtro_fecha_ini").val(fecha_ini);
                    $("#filtro_fecha_fin").val(fecha_fin);
                    var oTable = $('#tblListado').dataTable();
                    oTable.fnDestroy();
                    $("#tbContenedorListado").html(result);
                    aplidarDataTable('tblListado');
                    $("#dv_contenedor_listado").show("slide", {
                        direction: 'left'
                    }, 500);
                    wait.close();
                }
            });
        });
    });

});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error','Fechas','Verifique las fechas a filtrar');
        return false;
    }else{
        return true;
    }
}