$(document).ready(function () {
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");
    $(".datePicker").blur(function() {
        let value = $(this).val();
        let format = $(this).datepicker('option', 'dateFormat');
        let invalid = true;
        try {
            $.datepicker.parseDate(format, value);
            invalid = false;
        } catch (e) {}
        if (invalid) {
            crear_alerta('info', 'Atención', 'El valor ingresado no es una fecha válida');
            $(this).val('');
        }
    });

    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $("#frm-reportes").validate({
        rules: {
            txtFechaIni: {required: true},
            txtFechaFin: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error', 'Campos necesarios', 'Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form) {
            if (!validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val())) {
                crear_alerta('error', 'Filtros', 'Verifique el período de las fechas.');
                return false;
            }
            $("#filtro_inicio").val($("#txtFechaIni").val());
            $("#filtro_fin").val($("#txtFechaFin").val());

            var banco = ($("#slcBanco").val() > 0) ? $("#slcBanco").val() : "";
            $("#filtro_banco").val(banco);

            form.submit();
        }
    });


    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    /*Busqueda*/
    $("#btnConsultar").click(function () {

        var proveedor     = $("#slcProveedor").val();
        var clasificacion = $('#slcClasificacion').val();
        var fecha_fin     = $('#txtFechaFin').val();

        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('modulo_cuentas_pagar/reportes/reporte_antiguedad_saldos/1'),
                        data: {proveedor: proveedor,clasificacion:clasificacion,fecha_fin:fecha_fin},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                            $(".print").show();
                            var proveedor = $("#slcProveedor").val(); 

                            $("#filtro_proveedor").val(proveedor);
                            $("#filtro_clasificacion").val(clasificacion);
                            $("#filtro_fecha").val(fecha_fin);
                            var oTable = $('#tblListado').dataTable();
                            oTable.fnDestroy();

                            $("#tbContenedorListado").html(result);
                            aplidarDataTable('tblListado');

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);

                        }
                    });
                }
        );
    });


    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}