$(document).ready(function () {

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');
    $(".datePicker").blur(function() {
        let value = $(this).val();
        let format = $(this).datepicker('option', 'dateFormat');
        let invalid = true;
        try {
            $.datepicker.parseDate(format, value);
            invalid = false;
        } catch (e) {}
        if (invalid) {
            crear_alerta('info', 'Atención', 'El valor ingresado no es una fecha válida');
            $(this).val('');
        }
    });

    $('select').select2();  

    $("#btn_consultar").click(function () {
        event.preventDefault();
    
        var txtFechaIni     = $("#txtFechaIni").val();
        var txtFechaFin     = $("#txtFechaFin").val();
        var slc_proveedor   = ($.trim($("#slc_proveedor").val()) != "")?$("#slc_proveedor").val():'';
    
        var respuesta       = false;

        if ( txtFechaIni == "" || txtFechaFin == "") {
            crear_alerta('error', 'Reporte de Agenda de Pago', 'Por favor ingrese el rango de fechas.');
            $("#txtFechaIni").val("");
            return false;
        } 

        if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
            crear_alerta('error', 'Reporte de Agenda de Pago', 'Verifique el período de fechas.');
            return false;
        }

        $.ajax({
            url: window.gSateliteWhite.baseUrl('modulo_cuentas_pagar/reportes/reporte_agenda_pago'),
            data: {
                txtFechaIni: txtFechaIni,
                txtFechaFin: txtFechaFin,
                slc_proveedor: slc_proveedor,
                tipo_reporte: ""    
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor").html(obj.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            }
        });
    });

    $("#frm_reporte").validate({
        rules: {

        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var txtFechaIni         = $("#txtFechaIni").val();
            var txtFechaFin         = $("#txtFechaFin").val();

            var slc_proveedor       = ($("#slc_proveedor").val() > 0)?$("#slc_proveedor").val():'';
        
            var respuesta = false;

            if ( txtFechaIni == "" || txtFechaFin == "") {
                crear_alerta('error', 'Reporte de Agenda de Pago', 'Por favor ingrese el rango de fechas.');
                $("#txtFechaIni").val("");
                return false;
            } 

            if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
                crear_alerta('error', 'Reporte de Agenda de Pago', 'Verifique el período de fechas.');
                return false;
            }
    
            form.submit();
        }
    });


});