jQuery(document).ready(function ($) {
    $('select').select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
    $("input[name^='fecha'], input[name^='txtFecha']").blur(function() {
      let value = $(this).val();
      let format = $(this).datepicker('option', 'dateFormat');
      let invalid = true;
      try {
        $.datepicker.parseDate(format, value);
        invalid = false;
      } catch (e) {}
      if (invalid) {
        crear_alerta('info', 'Atención', 'El valor ingresado no es una fecha válida');
        $(this).val('');
      }
    });

    $("#txtFecha_desde,#txtFecha_hasta").change(function(event) {  validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta'); });

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            txtFecha_desde: {required: true},
            txtFecha_hasta: {required: true}
        },
        messages: {
            txtFecha_desde: "Campo requerido",
            txtFecha_hasta: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }
            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");
        },
        submitHandler: function (form) {
           $("#contenedorTabla").hide("slide", { 
            direction: 'right'
          }, 400, function() { //despues de ocultar div enviar el ajax

              url_ajax = window.satelite.base_url('modulo_cuentas_pagar/reportes/generar_reporte_det_antiguedad');
               $.ajax({
                   url: url_ajax,
                   type: 'POST',
                   dataType: 'json',
                   data: {
                       txtFecha_desde:   $("#txtFecha_desde").val(),
                       txtFecha_hasta:   $("#txtFecha_hasta").val(),
                       slcProveedores:   $("#slcProveedores").val(),
                       slcClasificacion: $("#slcClasificacion").val()

                   },
                   beforeSend: function () {
                       wait.start();
                   },
                   error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $("#contenedorTabla").html(json.html);
                    $("#contenedorTabla").show("slide", {
                      direction: 'left'
                    }, 500);
                    wait.close();

                }
            });
        });
       }
   });

  


});

