$(document).ready(function () {
    //   window.gSateliteWhite.jsSelect();
    $("select option[value='0']").text('');
    $("select option[value='0']").val('');
    if ($("#frp_att").val() > 0) {
        var val = $("#frp_att").val();
        var opctext = $("#slcFormapago option[value='" + val + "']").text();
        opctext = opctext + " (Disponible $" + $("#val_frp_att").val() + ")";
        $("#slcFormapago option[value='" + val + "']").text(opctext);
    }
    $('select').select2({placeholder: "Seleccione una opción"});

    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".txtFechas").mask('99-99-9999');

    $(".fecha").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
    $("#txtMonto").numeric();

    var factura = "";
    var ediciones_pendientes = 0;

    $("#frm-otrospagos").validate({
        ignore: "",
        rules: {
            txtFecha: {required: true},
            slcFormapago: {required: true},
            txtConcepto:{required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html('Campo requerido');
            wait.close();
        },
        submitHandler: function (form) {
            error = "";
            if ($("#tblDetalles .trDetalle").length == 0) {
                crear_alerta('error', 'Detalles', 'Debe agregar al menos un registro');
                wait.close();
                return false;
            }
            if (ediciones_pendientes != 0) {
                crear_alerta('error', 'Detalles', 'Posee documentos sin guardar');
                wait.close();
                return false;
            }
            form.submit();
        }
    });

    $("#slcProveedor").change(function () {
        $("#slcDocumento").select2('data', null);
        if ($("#slcProveedor").val() == "") {
            $("#txtOdenDe").val('');
            $("#slcDocumento").select2('disable');
            $("#slcCuentaCont").select2('data', null);
            $("#slcCuentaCont").select2('enable');
        } else {
            var proveedor_text = $("#slcProveedor option:selected").text();
            proveedor_text = proveedor_text.split("-");
            $("#txtOdenDe").val(proveedor_text.pop());
            var proveedor = $("#slcProveedor").val();

            $.ajax({
                url: urlj + "utm/cuentas/get_cuentas_cuenta_proveedor",
                type: 'POST',
                dataType: 'json',
                data: {proveedor: proveedor, tipo: 'COSTO'},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                    $("#slcCuentaCont").select2('data', {id: data.cuenta, text: data.cuenta_nombre});
                    $("#slcCuentaCont").select2('disable');
                }
            });
            $("#slcDocumento").select2('enable');
        }
    });

    $("#slcDocumento").select2({
        placeholder: 'Buscar factura',
        minimumInputLength: 1,
        ajax: {
            url: urlj + 'utm/cuentas/get_factura_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (factura) {
                return {
                    factura: factura,
                    proveedor: $("#slcProveedor").val()
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.dpv_id,
                        'text': item.dpv_numero_documento,
                        'data-tipo': item.dpv_concepto
                    });
                });
                return {
                    results: myResults
                };

            }
        }
    });

    $(".myModal").fancybox({
        width: '40%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {

        },
        beforeClose: function () {

        }
    });

    $("body").on('keypress', '.numero', function (event) {
        $(this).numeric();
        var text = $(this).val();
        if ((text.indexOf('.') != -1) && (text.substring(text.indexOf('.')).length > 2) && (event.which != 0 && event.which != 8) && ($(this)[0].selectionStart >= text.length - 2)) {
            event.preventDefault();
        }
    });
    $("#slcDocumento").select2('disable');

    var row = 0;
    if ($('#tbDetalles .trDetalle').length > 0) {
        row = $("#tbDetalles .trDetalle").length;
    }

    $("#btnAgregar").live("click", function (event) {
        event.preventDefault();

        var tipo = $("#txtTipo").val();
        var serie = $("#txtSerie").val();
        var factura = "";
        var txt_factura = "";
        var slcDocumento = $("#slcDocumento").val();
        var descripcion = $("#txtDescripcion").val();
        var monto = $("#txtMonto").val();
        var monto_sujeto = 0.00;
        var retencion = 0.00;
        var total = monto;
        var repetido = false;
        var proveedor = "";
         var monto_pendiente = $("#txtTmpMontoPendiente").val();


        if (slcDocumento == '') {
            crear_alerta('error', 'Formas de pago', 'Favor Seleccione una factura');
            return false;
        }

        if (monto <= 0 || monto == "") {
            crear_alerta('error', 'Formas de pago', 'Favor agregue un monto');
            $('#txtMonto').focus();
            return false;
        }

        if (slcDocumento != '') {
            if (parseFloat(monto) > parseFloat(monto_pendiente)) {
                crear_alerta('error', 'Formas de pagos', 'El monto no puede ser mayor a la deuda de la factura (' + monto_pendiente + ')');
                $('#txtMonto').focus();
                return false;
            }
        }

        if (slcDocumento != '') {
          var fdet = 0;
          var vf = true;
          $("#tblDetalles .trDetalle").each(function() {
          fdet = $(this).find(".facturaDetalle").val();
          if (fdet == slcDocumento && vf == true) {
            crear_alerta('error', 'Detalle', 'La Factura seleccionada ya fue agregada');
            $("#txtTipo").val('');
            $("#txtSerie").val('');
            vf = false;
          }
          });
        if (vf == false) {
          return false;
        }
            txt_factura = $("#slcDocumento").next('div').text();
            proveedor = $('#slcProveedor').val();
        }



        monto = parseFloat(monto);
        total = parseFloat(total);
        var html = '<tr id="tr_Detalle_' + row + '" class="trDetalle">';

        html += '<td>';
        html += '<label id="txtTablaTipo_' + row + '" class="text tables-input select-text">' + tipo + '</label>';
        html += '</td>';

        html += '<td>';
        html += '<label id="txtTablaSerie_' + row + '" class="text tables-input select-text">' + serie + '</label>';
        html += '</td>';

        html += '<td>';
        html += '<label id="txtTablaTextoFactura_' + row + '" class="text tables-input select-text">' + txt_factura + '</label>';
        html += '<input id="txtTablaProveedor_' + row + '" name="txtTablaProveedor[]" type="hidden" value="' + proveedor + '" />';
        html += '<input type="hidden" id="txtTablaFactura_' + row + '" name="hdnFactura[]" class="tables-input facturaDetalle" value="' + slcDocumento + '" />';
        html += '</td>';

        html += '<td>';
        html += '<textarea id="txtTablaDescripcion_' + row + '" name="txtTablaDescripcion[]" type="text" class="text tables-input-show tables-input" readonly="readonly" maxlength="300" style="resize:none;">' + descripcion + '</textarea>';
        html += '</td>';

        html += '<td>';
        html += '<input id="txtTablaMonto' + row + '" name="txtTablaMonto[]" type="text" class="text tables-input-show tables-input soloNumeros  monto numeric numero" extras="." readonly="readonly" value="' + monto.toFixed(2) + '"  maxlength="19"/>';
        html += '<input id="txtTablaMontoPend' + row + '" name="txtTablaMontoPend[]" type="hidden"  value="' + parseFloat(monto_pendiente).toFixed(2) + '"/>';
        html += '</td>';

        html += '<td>';
        html += '<input id="txtTablaRetenciones_id' + row + '" name="txtTablaRetenciones_id[]" type="hidden" class="text tables-input" readonly="readonly" value="" />';
        html += '<input id="txtTablaRetenciones_porcentaje' + row + '" name="txtTablaRetenciones_porcentaje[]" type="hidden" class="text tables-input" readonly="readonly" value=""  maxlength="19"/>';
        html += '<input id="txtTablaRetencion' + row + '" name="txtTablaRetencion[]" type="hidden" class="text tables-input retencion" readonly="readonly" value="' + retencion.toFixed(2) + '"  maxlength="19" />';
        html += '<label id="lbTablaRetencion' + row + '" style="display:inline">' + retencion.toFixed(2) + '</label>';
        html += '<input id="txtTablaMontoSujeto' + row + '" name="txtTablaMontoSujeto[]" type="hidden" class="text tables-input monto_sujeto" readonly="readonly" value="" />';
        html += '<a href="#myModal" style="margin-left: 10px;" class="myModal icon-table btnRetChe" id="' + row + '"><span class="icon16 icomoon-icon-list-view-2" value="' + row + '"></span></a>';
        html += '</td>';

        html += '<td>';
        html += '<input id="txtTablaTotal' + row + '" name="txtTablaTotal[]" type="text" class="text tables-input subtotal" readonly="readonly" value="' + total.toFixed(2) + '"  maxlength="19"/>';
        html += '</td>';

        html += '<td>';
        html += '<a href="javascript:void(0)" id="btnTablaGuardar' + row + '" class="btnGuardarChe" style="margin-left: 10px;display: none;" value="' + row + '"><span class="icon16  icomoon-icon-disk"></span></a>';
        html += '<a href="javascript:void(0)"  id="btnTablaEditar' + row + '" class="btnEditChe" style="margin-left: 10px;" value="' + row + '"><span class="icon16 icomoon-icon-pencil-5"></span></a>';
        html += '<a href="javascript:void(0)"  class="btnDelChe" style="margin-left: 10px;"><span class="icon16 icomoon-icon-remove"></span></a>';
        html += '</td>';

        html += '</tr>';

        var oTable = $('#tblDetalles').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbDetalles").append(html);
        aplicarDataTable('#tblDetalles');

        $("#slcFactura option:selected").removeAttr('selected');

        $("#txtDescripcion").val('');
        $("#txtMonto").val('');

        $("#txtTipo").val('');
        $("#txtSerie").val('');
        $("#txtTmpMontoPendiente").val('0');

        $("#slcDocumento").select2('data', null);

        total_monto();
        total_monto_sujeto();
        sumatoria_monto();
        total_retencion();
        $("#slcProveedor").select2('disable');
        row ++;
    });

    //Guardar cheque
    $(".btnGuardarChe").live('click', function () {
        event.preventDefault();

        var parent = $(this).parent().parent();

        var tr_id = $(this).val();

        if ($('#txtTablaMonto' + tr_id).val() == "" || $('txtTablaMonto' + tr_id).val() <= 0) {
            $('#txtTablaMonto' + tr_id).focus();
            crear_alerta('error', 'Cheques', 'EL monto debe ser mayor a 0');
            return false;
        }

        if (parseFloat($('#txtTablaMonto' + tr_id).val()) < parseFloat($('#txtTablaMontoSujeto' + tr_id).val())) {
            crear_alerta('error', 'Cheques', 'Monto no puede ser menor al monto sujeto');
            $('#txtTablaMonto' + tr_id).focus();
            return false;
        }

        if ($("#txtTablaFactura" + tr_id).val() != '') {
            if (parseFloat($('#txtTablaMonto' + tr_id).val()) > parseFloat($('#txtTablaMontoPendiente' + tr_id).val())) {
                crear_alerta('error', 'Cheques', 'El monto no puede ser mayor a la deuda de la factura (' + $('#txtTablaMontoPendiente' + tr_id).val() + ')');
                $('#txtTablaMonto' + tr_id).focus();
                return false;
            }
        }
        var monto = parseFloat($('#txtTablaMonto' + tr_id).val());
        $('#txtTablaMonto' + tr_id).val(monto.toFixed(2));
        //txtTablaMonto[]

        var total = parseFloat($('#txtTablaMonto' + tr_id).val() - $('#txtTablaRetencion' + tr_id).val());
        $('#txtTablaTotal' + tr_id).val(total.toFixed(2));

        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');

        $(this).hide();
        $("#" + parent[0].id + " .btnEditChe").show();
        total_monto();
        total_monto_sujeto();
        sumatoria_monto();
        total_retencion();
        ediciones_pendientes = ediciones_pendientes - 1;

        var newID = $(this).val();
        $("#" + newID).show();
    });

    //Editar cheque
    $(".btnEditChe").live('click', function () {
        ediciones_pendientes++;
        var parent = $(this).parent().parent();

        $("#" + parent[0].id + " .tables-input-show").removeClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").removeAttr('readonly');

        $(this).hide();
        $("#" + parent[0].id + " .btnGuardarChe").show();

        var newID = $(this).val();
        $("#" + newID).hide();
    });

    //Retencion de cheque
    $(".btnRetChe").live('click', function () {
        event.preventDefault();

        var id = $(this).attr('id');

        $('#sujeto').val('');
        $("#slcRetenciones").select2('data', null);
        $('#slcRetenciones').select2();

        var seleccionados = $('#txtTablaRetenciones_id' + id).val();
        var seleccionados_array = seleccionados.split(',');

        $('#sujeto').val($('#txtTablaMontoSujeto' + id).val());

        if (seleccionados != "") {
            $("#slcRetenciones option").each(function () {
                if (jQuery.inArray($(this).val(), seleccionados_array) != -1) {
                    $(this).attr("selected", "selected");
                }
            });
            $("#slcRetenciones").select2();
        }
        $('#txtTmpRetencion').val(id);

    });

    //eliminar
    $('#tblDetalles tbody').on('click', '.btnDelChe', function () {
        var table = $('#tblDetalles').DataTable();
        var parent = $(this).parent().parent();
        var nRow = $(parent).attr("id");
        table.fnDeleteRow(parent[0], null, true);
        total_monto();
        contar_filas();
        total_monto_sujeto();
        sumatoria_monto();
        total_retencion();
    });

    $("#slcDocumento").change(function () {
        get_datos_factura();
    });

    $("#guardar_modal").live("click", function () {
        event.preventDefault();

        var id = $('#txtTmpRetencion').val();
        var error = false;
        var porcentaje = 0;
        var retenciones = "";
        var porcentaje_tabla = "";
        var cantidad_seleccionados = 0;

        if ($('#sujeto').val() == "") {
            crear_alerta('error', 'Retencion', 'Ingrese el valor sujeto a retención');
            $('#sujeto').focus();
            error = true;
            return false;
        }

        if ($('#slcRetenciones').val() == "") {
            crear_alerta('error', 'Retención', 'Seleccione un tipo de retención');
            $('#sujeto').focus();
            error = true;
            return false;
        }

        if (parseFloat($('#sujeto').val()) > parseFloat($('#txtTablaMonto' + id).val())) {
            crear_alerta('error', 'Retención', 'Valor sujeto a retención es mayor que el monto, ($' + $('#txtTablaMonto' + id).val() + ')');
            $('#sujeto').focus();
            error = true;
            return false;
        }

        $('#slcRetenciones :selected').each(function (i, selected) {
            retenciones = retenciones + $(selected).val() + ",";
            porcentaje = porcentaje + $(selected).data("valor");
            porcentaje_tabla = porcentaje_tabla + $(selected).data("valor") + ",";
            cantidad_seleccionados++;
        });

        if (cantidad_seleccionados <= 0 && $('#sujeto').val() > 0) {
            crear_alerta('error', 'Retención', 'Debe seleccionar una retención');
            error = true;
            return false;
        }

        if (cantidad_seleccionados > 0 && $('#sujeto').val() <= 0) {
            crear_alerta('error', 'Retención', 'Valor sujeto debe ser mayor a 0');
            error = true;
            return false;
        }

        retenciones = retenciones.substring(0, retenciones.length - 1);
        porcentaje_tabla = porcentaje_tabla.substring(0, porcentaje_tabla.length - 1);

        $('#txtTablaRetenciones_id' + id).val(retenciones);
        $('#txtTablaRetenciones_porcentaje' + id).val(porcentaje_tabla);

        var sujeto = parseFloat($('#sujeto').val());

        calculo_retencion(porcentaje, sujeto.toFixed(2), id);

        if (error == false) {
            $.fancybox.close();
        }
    });

    $(document).on('change', '#slcProveedor', function() {
        val = $(this).val();
        console.log('aaaa: '+ val);
        if(val.length > 0){
            $('#link_modal').css('display', 'none');
            $('#contenedor_detalle').html('');
        }else{
            $('#link_modal').css('display', '');
        }
        //alert();
    });
});

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
    });
}

function get_datos_factura() {
    var result = null;
    if ($('#slcDocumento').val() != "") {
        var id_factura = $('#slcDocumento').val();
        $.ajax({
            url: urlj + "utm/cuentas/get_datos_factura",
            type: 'POST',
            dataType: 'json',
            data: {id_factura: id_factura},
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                wait.close();
                $("#txtTipo").val(data[0].tif_abreviacion);
                $("#txtSerie").val(data[0].dpv_serie_documento);
                var pendiente = parseFloat(data[0].dpv_monto_pendiente).toFixed(2);
                var descripcion = data[0].dpv_descripcion;

                $("#txtDescripcion").val(descripcion);
                $("#txtMonto").val(pendiente);
                $("#txtTmpMontoPendiente").val(pendiente);
            }
        });
    } else {
        ("#txtDescripcion").val('');
        $("#txtMonto").val('');
        $("#txtTmpMontoPendiente").val('');
    }
}

function consultar_numero() {
    numero = $("#txtNumero").val();
    id_chequera = $("#slcChequera").val();
    $.ajax({
        url: urlj + "utm/cuentas/validar_num_cheque",
        type: 'POST',
        dataType: 'json',
        data: {id_chequera: id_chequera, numero: numero},
        success: function (data) {
            if (data.resp == 1) {
                crear_alerta('error', 'Informaci&oacute;n', 'El número de cheque fuera del rango');
                $("#txtNumero").val('');

            }
            if (data.resp == 2) {
                crear_alerta('error', 'Informaci&oacute;n', 'El número de cheque ya fue usado');
                $("#txtNumero").val('');
            }
            $("#frmAgregarCheque").submit();
        }
    });
}

function calculo_retencion(porcentaje, valor_sujeto, id) {
    var retencion = 0;
    var sub_total = 0;

    retencion = (valor_sujeto * porcentaje) / 100;
    sub_total = $('#txtTablaMonto' + id).val() - retencion;
    $('#txtTablaMontoSujeto' + id).val(number_format(valor_sujeto, 2));
    $('#txtTablaRetencion' + id).val(number_format(retencion, 2));
    $('#lbTablaRetencion'+ id).text(number_format(retencion, 2));
    $('#txtTablaTotal' + id).val(number_format(sub_total, 2));

    $('#sujeto').val('');
    $("#slcRetenciones").select2('data', null);
    total_monto();
    total_monto_sujeto();
    sumatoria_monto();
    total_retencion();
    $.fancybox.close();
}

//subtotal
function total_monto() {
    suma = 0;
    celda = "";
    $('.subtotal').each(function () {
        celda = $(this).val();
        suma += parseFloat(celda || 0, 10);
    });
    suma = suma.toFixed(2);
    $('#txt_valor_monto').val(number_format(suma, 2));
}

function total_retencion() {
    suma = 0;
    celda = "";
    $('.retencion').each(function () {
        celda = $(this).val();
        suma += parseFloat(celda || 0, 10);
    });
    suma = suma.toFixed(2);
    $('#txt_ret_total').val(number_format(suma, 2));
}

function total_monto_sujeto() {
    suma = 0;
    celda = "";
    $('.monto_sujeto').each(function () {
        celda = $(this).val();
        suma += parseFloat(celda || 0, 10);
    });
    suma = suma.toFixed(2);
    $('#txt_total_monto_sujeto').val(number_format(suma, 2));
}

function contar_filas() {
    var suma = 0;
    $(".tr_Detalle").each(function () {
        suma++;
    });

    if (suma == 0) {
        $("#slcProveedor").select2('enable');
    }
}

//sumataria de monto
function sumatoria_monto() {
    suma = 0;
    celda = "";
    $('.monto').each(function () {
        celda = $(this).val();
        suma += parseFloat(celda || 0, 10);
    });
    suma = suma.toFixed(2);
    $('#txt_total_monto').val(suma);
}
