$(document).ready(function () {
    //$('#checkh').attr("disabled", true);
    var total_checbox = 0;
    var idcheques = ''; 

    $('select').select2({placeholder: "Seleccione una opción"});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $(".soloNumeros").numeric();

    $("#slcProveedor").select2({
        placeholder: "Buscar Proveedor",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_cuentas_pagar/procesos/get_proveedores',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (proveedor) {
                return {
                    proveedor: proveedor
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.proveedor,
                        'text': item.nombre_proveedor
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var id_elemento = element[0].id;
            var valor = $("#" + id_elemento).val();
            if (valor !== "") {
                var texto = $("#" + id_elemento).data('nombre');
                callback({id: valor, text: texto});

            }
        }
    });


    /*Busqueda*/
    $("#btnConsultar").click(function () {
        var proveedor = $("#slcProveedor").val();
        var tipo_pago = $("#slcTipoPago").val();

        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('modulo_cuentas_pagar/procesos/aprobacion_agenda/1'),
                        data: {proveedor: proveedor, tipo_pago: tipo_pago},
                        dataType: 'json',
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            var oTabla = $("#tblListado").dataTable();

                            oTabla.fnDestroy();
                            $("#tbContenedorListado").html(result.html);

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);

                            $("#txtMontoTotal").val(number_format(result.monto_total, 2));

                            var proveedor = $("#slcProveedor").val();
                            $("#btnLimpiarAgenda").show('500');

                            $("#filtro_proveedor").val(proveedor);

                            $("#dvAcciones").show('500');
                            $(".soloNumeros").numeric();
                            setTimeout(function () {
                                aplicarEstiloCheckbox();
                                aplicarDataTable('tblListado');
                                total_checbox = $('#tbContenedorListado tr').length;                        
                                wait.close();
                            }, 500);
                        }
                    });
                }
        );
    });

    $("#btnCrear").click(function () {
        wait.start();
        var oTabla = $("#tblListado").dataTable();
        oTabla.fnDestroy();
        if ($("#tbContenedorListado > tr .error").length > 0) {
            wait.close();
            crear_alerta('error', 'Agenda de pagos', 'Verifique los montos a pagar.');
            aplicarDataTable('tblListado');
            return false;
        }
    });

    $(".btnLimpiar").live('click', function () {
        var parent = $(this).parent().parent();

        var data_id = $("#" + parent[0].id).attr('data-id');

        $("#txtPagar_" + data_id).val('');
        $("#slcTipo_" + data_id + " option:selected").removeAttr('selected');
        $("#slcTipo_" + data_id + "").select2({placeholder: "Seleccione una opción"});
    });

    $(".montoPagar").live('keyup', function () {

        var montoPago = $(this).val();
        if (montoPago != '') {
            montoPago = parseFloat(montoPago);

            var parent = $(this).parent().parent();

            var data_id = $("#" + parent[0].id).attr('data-id');

            var saldo = $("#txtSaldoTotal_" + data_id).val().replace("$", "").replace(/,/g, "");

            saldo = parseFloat(saldo);

            if (saldo < montoPago) {
                $(this).addClass('error');
            } else {
                $(this).removeClass('error');
            }
        }
    });

    //Verifica cuando hace el cambio en el boton
    $(document).on('change','.checkb',function(){                
        marcados = 0;
        $('.checkb').each(function() {
            if($(this).is(":checked")){
                marcados++;
            }            
        })
        if(marcados == total_checbox){                     
            $('#checkh').attr('checked',true);            
        }else{            
            $('#checkh').attr('checked',false);
        }        
        // console.log('total check: ' + total_checbox);
        // console.log('marcados: ' + marcados);
    });

    //Verificar si hace click en check de la cabecera
    $(document).on('click','#checkh',function(){        
        if($(this).is(":checked")){
            $('.checkb').click();
            //$('.checkb').attr('checked',true);
            $('.checkb').iButton("repaint");
            var idData = $('.checkb').attr('data-id');
            $(".checkhidden").val(1);                        
        }else{
            $('.checkb').click();            
            //$('.checkb').attr('checked',false);            
            $('.checkb').iButton("repaint");
            var idData = $('.checkb').attr('data-id');
            $(".checkhidden").val(0);            
        }        
        calcularMontoAprobadoAux();               
        aplicarEstiloCheckbox();
        
    });

    //Se restablecen los valores para al cambiar de pagina
    $(document).on('click','.paginate_button',function(){        
        $('#checkh').attr('checked',false);

        if($('#checkh').is(":checked")){
            $('.checkb').attr('checked',true);
            $('.checkb').iButton("repaint");
            var idData = $('.checkb').attr('data-id');
            $(".checkhidden").val(1);                        
        }else{
            $('.checkb').attr('checked',false);            
            $('.checkb').iButton("repaint");
            var idData = $('.checkb').attr('data-id');
            $(".checkhidden").val(0);            
        }

        calcularMontoAprobadoAux();
    });


    $("body").on("click", "#btnLimpiarAgenda", function () {
        $("#tblListado").dataTable().fnDestroy();

        $(".montoPagar").val('');
        $("[name='tipoPagos[]'] option:selected").removeAttr('selected');
        $("[name='tipoPagos[]']").select2({placeholder: "Seleccione una opción"});

        var tamanio = $("#tbContenedorListado tr").length;
        if (tamanio > 0) {
            alerta_confirm_custom(limpiar_aprobacion_pagos, setAccion_Cancelar, "", "Alerta confirmación", "¿Ésta seguro que quieres Limpiar Aprobación de agenda de pagos?");
        } else {
            crear_alerta("error", "Aprobación de agenda de pagos", "No hay registros");
            aplicarDataTable("tblListado");
            $("#tblListado").css("width", "100%");
        }

    });    
                
});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 5,        
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function aplicarEstiloCheckbox() {    
    $(".chkAprobar").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {            
            var data_id = $("#" + element[0].id).attr('data-id');

            if (element.is(':checked')) {
                $("#hdnAprovar_" + data_id).val(1);
                $("#hdnAprovar_" + data_id).attr('name', 'hdnAprobarAgenda[]');
                $("#hdnAgenda_" + data_id).attr('name', 'agendas[]');
                $("#hdnDocumento_" + data_id).attr('name', 'hdnDocumento[]');
                $("#hdnTipoPago_" + data_id).attr('name', 'hdnTipoPago[]');

                $("#hdnConcepto_" + data_id).attr('name', 'conceptos[]');
                $("#txtProveedor_" + data_id).attr('name', 'proveedores[]');
                $("#txtPagar_" + data_id).attr('name', 'montoPagar[]');
            } else {
                $("#hdnAgenda_" + data_id).removeAttr('name');
                $("#hdnAprovar_" + data_id).val(0);
                $("#hdnAprovar_" + data_id).removeAttr('name');

                $("#hdnDocumento_" + data_id).removeAttr('name');
                $("#hdnConcepto_" + data_id).removeAttr('name');
                $("#txtProveedor_" + data_id).removeAttr('name');
                $("#txtPagar_" + data_id).removeAttr('name');
                $("#hdnTipoPago_" + data_id).removeAttr('name');
            }
            calcularMontoAprobado();
        }        
    });
}

function calcularMontoTotal() {

    var montoTotal = 0;
    $("#tbContenedorListado tr").each(function () {
        var idData = $(this).attr('data-id');
        var monto = $("#txtPagar_" + idData).val().replace(/,/g, "");
        montoTotal += parseFloat(monto);

    });
    $("#txtMontoTotal").val(number_format(montoTotal, 2));
}

function calcularMontoAprobado() {

    var montoAprobado = 0;
    $("#tbContenedorListado tr").each(function () {
        var idData = $(this).attr('data-id');
        var chkAprobado = $("#hdnAprovar_" + idData).val();
        var monto = $("#txtPagar_" + idData).val().replace(/,/g, "");

        if (chkAprobado == 1) {
            montoAprobado += parseFloat(monto);
        }

    });


    $("#txtMontoAprobado").val(number_format(montoAprobado, 2));
}

function calcularMontoAprobadoAux() {

    var montoAprobado = 0;
    $("#tbContenedorListado tr").each(function () {
        var idData = $(this).attr('data-id');
        var chkAprobado = $("#hdnAprovar_" + idData).val();
        var monto = $("#txtPagar_" + idData).val().replace(/,/g, "");

        if (chkAprobado == 1) {
            montoAprobado +=  parseFloat(monto);
        }
        console.log(montoAprobado);
    });


    $("#txtMontoAprobado").val(number_format(montoAprobado, 2));
}

function limpiar_aprobacion_pagos(parametro = null) {

    var oTabla = $("#tblListado").dataTable();
    oTabla.fnDestroy();

    wait.start();
    // Limpiar datos
    var agenda = 1;
    $.ajax({
        type: 'post',
        url: window.gSateliteWhite.baseUrl('modulo_cuentas_pagar/procesos/set_agenda_pendiente'),
        data: {agenda: agenda},
        async: false,
        beforeSend: function () {
            // wait.start();
        },
        success: function (result) {
            // wait.close();                
        }                        
    });

    $("#btnConsultar").trigger("click");

    aplicarDataTable("tblListado");
    $("#tblListado").css("width", "100%");

    setTimeout(function () {
        wait.close();
    }, 500);
}

function setAccion_Cancelar(parametro = null) {
    aplicarDataTable("tblListado");
    $("#tblListado").css("width", "100%");
}

function alerta_confirm_custom(funcion_aceptar, funcion_cancelar ,parametro = null,titulo, mensaje) {
    $("body").append('<div id="dialog_alerta_confirm" style="display:none;" title="Confirmar"><p><span class="icon16  icomoon-icon-warning black" style="float:left; margin:0 7px 20px 0;"></span><span id="dialog_alerta_confirm_text"></span></p></div>');    
    $("#dialog_alerta_confirm_text").html(mensaje);
    $( "#dialog_alerta_confirm" ).dialog({
        resizable: false, 
        position: 'top',
        draggable: false,
        title: titulo,
        show: {
            effect: "slideDown",
            duration: 400
        }, hide: {
            effect: "slideUp",
            duration: 300
        },
        modal: true,
        close: function(event, ui) { setTimeout(function(){ $("#dialog_alerta_confirm").remove(); }, 300); },
        height: 150,
        width: 250,
        overlay: { backgroundColor: "#000", opacity: 0.5 },
        buttons: {
            "Aceptar": function() {
                $( this ).dialog( "close" );
                funcion_aceptar(parametro);
                $("#dialog_alerta_confirm").remove();
            },
            "Cancelar": function() {
                $( this ).dialog( "close" );
                funcion_cancelar(parametro);
                $("#dialog_alerta_confirm").remove();
            }
        }
    });
}