$(document).ready(function () {
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $("#slcProveedor").select2({
        placeholder: "Buscar Proveedor",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_cuentas_pagar/procesos/get_proveedores',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (proveedor) {
                return {
                    proveedor: proveedor
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.proveedor,
                        'text': item.nombre_proveedor
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var id_elemento = element[0].id;
            var valor = $("#" + id_elemento).val();
            if (valor !== "") {
                var texto = $("#" + id_elemento).data('nombre');
                callback({id: valor, text: texto});

            }
        }
    });

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");
    $(".datePicker").blur(function() {
        let value = $(this).val();
        let format = $(this).datepicker('option', 'dateFormat');
        let invalid = true;
        try {
            $.datepicker.parseDate(format, value);
            invalid = false;
        } catch (e) {}
        if (invalid) {
            crear_alerta('info', 'Atención', 'El valor ingresado no es una fecha válida');
            $(this).val('');
        }
    });

    /*Busqueda*/
    $("#btnConsultar").click(function () {
        var proveedor   = $("#slcProveedor").val();
        var fecha_venc  = $("#txtFechaVencimiento").val();

        if (fecha_venc == '') {
            crear_alerta('info', 'Agenda de pagos', 'Ingrese una fecha de vencimiento.');
            return false;
        }
        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('modulo_cuentas_pagar/procesos/agenda_pagos/1'),
                        data: {proveedor: proveedor, fecha_venc: fecha_venc},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                            var oTabla     = $("#tblListado").dataTable();
                            montoTotal     = 0;

                            oTabla.fnDestroy();
                            $("#tbContenedorListado").html(result);

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);

                            var proveedor  = $("#slcProveedor").val();
                            var fecha_venc = $("#txtFechaVencimiento").val();

                            $("#filtro_fecha").val(fecha_venc);
                            $("#filtro_proveedor").val(proveedor);

                            $("#dvAcciones").show('500');
                            $("#btnLimpiarAgenda").show('500');

                            $("#txtMontoPagar").val('$0.00');
                            $("#btnCrear").attr('disabled', true);
                            $("#btnCrearp").attr('disabled', true);
                            //$(".soloNumeros").numeric();
                            setTimeout(function () {
                                $('.tipoPago').select2({placeholder: "Seleccione una opción"});
                                aplidarDataTable('tblListado');
                                $("#tblListado").css("width", "100%");
                            }, 500);
                            contar_pagos();
                        }
                    });
                }
        );
        $("#slcTipoPagoTodo").val(0);
        $("#slcTipoPagoTodo").select2({placeholder: "Seleccione una opción"});
    });

    $("#btnCrearp").click(function(){
      $("#txtpagar").val(1);
      alerta_confirm_ajax(guardarPagar,'','Alerta de Confirmación','¿Éstas seguro que deseas guardar y autorizar los documentos seleccionados?');
    });

    $("#btnCrear").click(function () {
        $("#txtpagar").val('');
        wait.start();
        if ($("#tbContenedorListado > tr .error").length > 0) {
            wait.close();
            crear_alerta('error', 'Agenda de pagos', 'Verifique los montos a pagar.');
            return false;
        }

        var invalidos       = 0;
        $("#tbContenedorListado > tr").each(function () {
            var idData      = $(this).attr('data-id');
            var monto       = $("#txtPagar_" + idData).val();
            var tipoPago    = $("#slcTipo_" + idData).val();
            if(!$("#txtPagar_" + idData).is(':disabled')){
                // if (monto == '' && tipoPago > 0) {
                //     invalidos++;
                // }
                // if (monto > 0 && tipoPago == '') {
                //     invalidos++;
                // }
            }
        });

        if (invalidos > 0) {
            wait.close();
            crear_alerta('error', 'Agenda de pagos', 'Complete los campos necesarios.');
            return false;
        }

        var oTabla = $("#tblListado").dataTable();
        oTabla.fnDestroy();

        setTimeout(function () {
            $("#frm-listado").submit();
        }, 500);

    });

    $("#btnLimpiarAgenda").click(function () {
        alerta_confirm_custom(set_Limpiar_agenda_pago, setAccion_Cancelar, "", "Alerta confirmación", "¿Ésta seguro que quieres Limpiar Agenda de pagos?");
    });

    $(".btnLimpiar").live('click', function () {
        var parent  = $(this).parent().parent();
        var data_id = $("#" + parent[0].id).attr('data-id');
        var cantidad = $("#txtPagar_" + data_id).val();     // Variable obteniendo valor

        if (montoTotal>0) {
            montoTotal  -= parseFloat(cantidad);            // Resta al Monto Total Global
        }

        $("#txtMontoPagar").val('$'+number_format(montoTotal, 2));   // Mostrar Total

        if(montoTotal > 0){
            $("#btnCrear").attr('disabled', false);
            $("#btnCrearp").attr('disabled', false);
        }else{
            $("#btnCrear").attr("disabled", true);
            $("#btnCrearp").attr("disabled", true);
        }

        // Limpiar datos
        var agenda = $("#hdnAgenda_"+data_id).val();
        $.ajax({
            type: 'post',
            url: window.gSateliteWhite.baseUrl('modulo_cuentas_pagar/procesos/set_agenda_pendiente'),
            data: {agenda: agenda},
            async: false,
            beforeSend: function () {
                // wait.start();
            },
            success: function (result) {
                // wait.close();
            }
        });

        $("#txtPagar_" + data_id).val(''); // Limpiar Campo
        $("#slcTipo_"  + data_id + " option:selected").removeAttr('selected');
        $("#slcTipo_"  + data_id + "").select2({placeholder: "Seleccione una opción"});
    });

    $("body").on('focus', '.montoPagar', function (e) {
        if ($(this).hasClass('error')) {
            $(this).select();
        }
    });

    // Codigo Comentado, ya que no se necesita el evento keyup
    // ************************************************************************************************ \\
    // $("body").on('keyup', ".montoPagar", function () {
    //     $("#btnCrear").removeAttr('disabled');
    //     var montoPago   = $(this).val();
    //     if (montoPago != '') {
    //         montoPago   = parseFloat(montoPago);
    //         var parent  = $(this).parent().parent();
    //         var data_id = $("#" + parent[0].id).attr('data-id');
    //         var saldo   = $("#txtSaldoTotal_" + data_id).val().replace("$", "").replace(/,/g, "");
    //         saldo       = parseFloat(saldo);
    //         if (saldo < montoPago) {
    //             $(this).addClass('error');
    //         } else if (montoPago == 0) {
    //             $(this).addClass('error');
    //         } else {
    //             $(this).removeClass('error');
    //         }
    //     }
    //     calcularMontoPagar();
    //     var total       = $("#txtMontoPagar").val();

    //     if (total == 0) {
    //         $("#btnCrear").attr('disabled', 'disabled');
    //     }
    // });

    // $("body").on('click', "#btnLimpiarAgenda", function () {
    //     calcularMontoPagar();
    // });

    // Se comento ya que la funcion que sumaba o restaba se cambio
    // $("body").on('change', ".tipoPago", function () {
    //     calcularMontoPagar();
    // });
    // ************************************************************************************************ \\


    $(document).on('change', '.tipoPago', function() {
        contar_pagos();
    });

    $(document).on('keyup', '.montoPagar', function() {
        var pago = $(this).val();
        var pdte = $(this).data('pdte');
        if (parseFloat(pago) > parseFloat(pdte)) {
            crear_alerta('warning','','Monto Ingresado No debe superar Monto a Pagar');
            $(this).val(pdte);
            $(this).blur();
        }
        contar_pagos();
    });

    $("body").on("change", "#slcTipoPagoTodo", function(e) {
        $("#tblListado").dataTable().fnDestroy();

        var tabla = $("#tbContenedorListado tr").length;
        if (tabla === 0) {
            crear_alerta("error", "No hay registros", "Debe realizar una busqueda");
            $(this).val(0);
            $(this).select2();
            aplidarDataTable("tblListado");
            $("#tblListado").css("width", "100%");
            return false;
        }
        alerta_confirm_custom(set_Todo_TipoPago, setAccion_Cancelar, this, "Alerta confirmación", "¿Ésta seguro que quieres colocar a todos los selectores este tipo de pago?");
    });

    $("#show_modal").fancybox();
});

function contar_pagos(){
    var idData      = "";
    var montoTotal  = parseFloat(0);
    var monto       = 0;

    $( ".tipoPago" ).each(function() {
        idData    = $(this).attr('data-id');
        if ($(this).attr("disabled")!= "disabled" && $(this).val() != ""  && $("#txtPagar_"+idData).val() ){
            monto = $("#txtPagar_"+idData).val().replace(/,/g, "");
            montoTotal += parseFloat( monto );
        }
    });

    $("#txtMontoPagar").val('$'+number_format(montoTotal, 2));

    if(montoTotal > 0){
        $("#btnCrear").attr('disabled', false);
        $("#btnCrearp").attr('disabled', false);
    }else{
        $("#btnCrear").attr("disabled", true);
        $("#btnCrearp").attr("disabled", true);
    }
}

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

// Funcion para calcular el monto a pagar
function calcularMontoPagar() {

    // var montoTotal = 0;
    $("#tbContenedorListado tr").each(function () {

        var idData = $(this).attr('data-id');
        var monto  = $("#txtPagar_" + idData).val();
        var tipoPago = $("#slcTipo_" + idData).val();
        if (monto != '' && tipoPago != '') {
            suma = monto.replace(/,/g, "");
            montoTotal += parseFloat(suma);
        }
    });

    $("#txtMontoPagar").val('$'+number_format(montoTotal, 2));
}

function set_Todo_TipoPago(selector) {
    var slcTipoPagoTodo = $(selector).val();

    wait.start();
    montoTotal = 0;
    if (slcTipoPagoTodo !== "") {
        $( ".tipoPago" ).each(function() {
            idData    = $(this).data('id');
            var slcTipo = $("#slcTipo_"+idData);
            if (!slcTipo.attr("disabled")) {
                slcTipo.val(slcTipoPagoTodo);
                slcTipo.select2();
            }
        });
        contar_pagos();
    } else {
        $( ".tipoPago" ).each(function() {
            idData    = $(this).data('id');
            var slcTipo = $("#slcTipo_"+idData);
            if ( slcTipo.val() !== "" && !slcTipo.attr("disabled") ){
                slcTipo.val(0);
                slcTipo.attr("placeholder", "Seleccione una opcion");
                slcTipo.select2();
            }
        });
        contar_pagos();
    }

    aplidarDataTable("tblListado");
    $("#tblListado").css("width", "100%");
    setTimeout(function(){
        wait.close();
    }, 1000);
}

function setAccion_Cancelar() {
    $("#slcTipoPagoTodo").val(0);
    $("#slcTipoPagoTodo").attr("placeholder", "Seleccione una opcion");
    $("#slcTipoPagoTodo").select2();
    aplidarDataTable("tblListado");
    $("#tblListado").css("width", "100%");
}

function alerta_confirm_custom(funcion_aceptar, funcion_cancelar ,parametro = null,titulo, mensaje) {
    $("body").append('<div id="dialog_alerta_confirm" style="display:none;" title="Confirmar"><p><span class="icon16  icomoon-icon-warning black" style="float:left; margin:0 7px 20px 0;"></span><span id="dialog_alerta_confirm_text"></span></p></div>');
    $("#dialog_alerta_confirm_text").html(mensaje);
    $( "#dialog_alerta_confirm" ).dialog({
        resizable: false,
        position: 'top',
        draggable: false,
        title: titulo,
        show: {
            effect: "slideDown",
            duration: 400
        }, hide: {
            effect: "slideUp",
            duration: 300
        },
        modal: true,
        close: function(event, ui) { setTimeout(function(){ $("#dialog_alerta_confirm").remove(); }, 300); },
        height: 150,
        width: 250,
        overlay: { backgroundColor: "#000", opacity: 0.5 },
        buttons: {
            "Aceptar": function() {
                $( this ).dialog( "close" );
                funcion_aceptar(parametro);
                $("#dialog_alerta_confirm").remove();
            },
            "Cancelar": function() {
                $( this ).dialog( "close" );
                funcion_cancelar(parametro);
                $("#dialog_alerta_confirm").remove();
            }
        }
    });
}

function set_Limpiar_agenda_pago() {
    wait.start();

    var oTabla = $("#tblListado").dataTable();
    oTabla.fnDestroy();

    $("#tbContenedorListado tr").each(function () {
        var idData = $(this).attr('data-id');
        var tipoPago = $("#slcTipo_" + idData);
        var id = $(this).attr('id');
          $('#'+id).remove();
       /* if (tipoPago.prop("disabled")) {
            $('#'+id).remove();
        }*/

       agenda = (typeof $(this).attr('agenda') === "undefined")?$(this).attr('agenda'):null;
       if (agenda) {       

        $.ajax({
        type: 'post',
        url: window.gSateliteWhite.baseUrl('modulo_cuentas_pagar/procesos/set_agenda_pendiente'),
        data: {agenda: agenda},
        async: false,
        beforeSend: function () {
            // wait.start();
        },
        success: function (result) {
            // wait.close();
        }
    });
 } 


    });

    $(".montoPagar").val('');
    $("[name='tipoPagos[]'] option:selected").removeAttr('selected');
    $("[name='tipoPagos[]']").select2({placeholder: "Seleccione una opción"});
    aplidarDataTable('tblListado');

    $("#txtMontoPagar").val('$0.00');
    montoTotal = 0;

    if(montoTotal > 0){
        $("#btnCrear").attr('disabled', false);
        $("#btnCrearp").attr('disabled', false);
    }else{
        $("#btnCrear").attr("disabled", true);
        $("#btnCrearp").attr('disabled', true);
    }

    // Limpiar datos
    //var agenda = 1;
   

    setTimeout(function () {
        wait.close();
    }, 500);
}

function guardarPagar() {
  wait.start();
  if ($("#tbContenedorListado > tr .error").length > 0) {
      wait.close();
      crear_alerta('error', 'Agenda de pagos', 'Verifique los montos a pagar.');
      return false;
  }

  var invalidos       = 0;
  $("#tbContenedorListado > tr").each(function () {
      var idData      = $(this).attr('data-id');
      var monto       = $("#txtPagar_" + idData).val();
      var tipoPago    = $("#slcTipo_" + idData).val();
      if(!$("#txtPagar_" + idData).is(':disabled')){
          // if (monto == '' && tipoPago > 0) {
          //     invalidos++;
          // }
          // if (monto > 0 && tipoPago == '') {
          //     invalidos++;
          // }
      }
  });

  if (invalidos > 0) {
      wait.close();
      crear_alerta('error', 'Agenda de pagos', 'Complete los campos necesarios.');
      return false;
    }
    var oTabla = $("#tblListado").dataTable();
    oTabla.fnDestroy();

    setTimeout(function () {
        $("#frm-listado").submit();
    }, 500);
 }
