$(document).ready(function () {

    $(".fechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".fechas").mask('99-99-9999');

    $('select').select2();

    $("#slcCliente").select2({
        placeholder:'Buscar clientes',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'modulo_cuentas_cobrar/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cli_id,
                        'text': item.cli_codigo+" - "+item.nombre,
                    });
                });
                return {
                    results: myResults
                };
		    } 
        }
    });

    $("#txtFecha_desde, #txtFecha_hasta").change(function(event) {
        var start = $("#txtFecha_desde").val();
        var final = $("#txtFecha_hasta").val();
        if (start != "" && final != "") {
            verifica_fecha(start, final);
        }
    });

    $("#btnConsultar").click(function (event) {
        $(".exportame").hide();
        event.preventDefault();
        var txtFechaIni = $("#txtFecha_desde").val();
        var txtFechaFin = $("#txtFecha_hasta").val();
        var txtcliente  = $("#slcCliente").val();
        var txtvendedor = $("#slcVendedor").val();
        var txtcobrador = $("#slcCobrador").val();
        if (txtFechaIni == "" || txtFechaFin == "") {
            crear_alerta('error', 'Por favor ingrese el rango de fechas.');
            return false;
        }
        if (!verifica_fecha(txtFechaIni, txtFechaFin)) {
            return false;
        }
        $.ajax({
            url: urlj + 'modulo_cuentas_cobrar/reportes/seguimiento_cuentas_cobrar/1',
            type: "POST",
            dataType: "json",
            data: {
                fecha_inicio: txtFechaIni,
                fecha_final: txtFechaFin,
                cliente:  txtcliente,
                vendedor: txtvendedor,
                cobrador: txtcobrador,
                tipo_reporte: ""    
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                $("#contenedorTabla").html(result.tabla);
                if (result.filas > 0) {
                    $("#fecha_inicio").val(txtFechaIni);
                    $("#fecha_final").val(txtFechaFin);
                    $("#cliente").val(txtcliente);
                    $("#vendedor").val(txtvendedor);
                    $("#cobrador").val(txtcobrador);
                    $(".exportame").show();
                }
                wait.close();
            }
        });
    });

});

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error', 'Verifique las fechas del período');
        return false;
    } else {
        return true;
    }
}