$(document).ready(function () {
    gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');
    $("#slcEstado").select2();

    $("#slcCliente").select2({
        placeholder: 'Buscar cliente',
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_cuentas_cobrar/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cli_id,
                        'text': item.cli_codigo + " - " + item.nombre,
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({ id: valor, text: texto });
                $("#" + idElemento).select2('disable');
            }
        }
    });

    $("#form_reporte_personal_factura").validate({
        ignore:"",
        rules: {
            txtFechaIni:{ required:true},
            txtFechaFin:{ required:true},
            slcCliente:{ required:true,min:1},
            //slcVendedor:{ required:true,min:1},
            //slcPago:{ required:true,min:1}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $("#imprimir_factura").live("click", function(){
        $("#form_reporte_personal_factura").attr('action','imprimir_reporte_abono_cliente/');
        var tipo = 'excel';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var cliente = $("#slcCliente").val();
        var cliente_data = (cliente > 0) ? $('#slcCliente').select2('data') : "";
        var txtcliente = (cliente > 0) ? cliente_data['text'] : "";

        $("#txtCliente").val(txtcliente);
        $("#txtVendedor").val($("#slcVendedor option:selected").text());
        $("#txtPago").val($("#slcPago option:selected").text());
        if(!$("#form_reporte_personal_factura").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el periodo de las fechas.');
                return false;
            }
        }
        $("#tipo_reporte").val(tipo);
        $("#form_reporte_personal_factura").submit();
    });

    $("#imprimir_factura_pdf").live("click", function(){
        $("#form_reporte_personal_factura").attr('action','imprimir_reporte_abono_cliente/');
        var tipo = 'pdf';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var cliente = $("#slcCliente").val();
        var cliente_data = (cliente > 0) ? $('#slcCliente').select2('data') : "";
        var txtcliente = (cliente > 0) ? cliente_data['text'] : "";
        $("#txtCliente").val(txtcliente);
        $("#txtVendedor").val($("#slcVendedor option:selected").text());
        $("#txtPago").val($("#slcPago option:selected").text());
        if(!$("#form_reporte_personal_factura").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el periodo de fechas.');
                return false;
            }
        }
        $("#tipo_reporte").val(tipo);
        $("#form_reporte_personal_factura").submit();
    });

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var cliente = $("#slcCliente").val();
        var vendedor = $("#slcVendedor").val();
        var pago = $("#slcPago").val();
        var cliente_data = (cliente > 0) ? $('#slcCliente').select2('data') : "";
        var txtcliente = (cliente > 0) ? cliente_data['text'] : "";
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        if(!$("#form_reporte_personal_factura").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique el periodo de fechas.');
               return false;
            }
        }
        $("#dv_contenedor_reg").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                   type:'post',
                   url:window.gSateliteWhite.baseUrl('modulo_cuentas_cobrar/reportes/reporte_abono_cliente/1'),
                   data:{cliente:cliente,vendedor:vendedor,pago:pago,fecha_ini:fecha_ini,fecha_fin:fecha_fin,textocliente:txtcliente},
                   beforeSend:function(){
                       wait.start();
                   },
                   success:function(result){
                       $('#encabezado').show();
                        $("#datagried").html(result);
                        $("#control").show();
                        $("#imprimir_factura").show();
                        $("#imprimir_factura_pdf").show();
                        wait.close();
                        $("#dv_contenedor_reg").show("slide", {
                           direction: 'left'
                        }, 500);
                   }
                });
            }
        );

   });
   
   
   $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#txtFechaFin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#txtFechaFin").removeClass('error');
        $("#txtFechaFin_error").text('');
        return true;
    }
}