$(document).ready(function(){
    $(".datePicker").mask("99-99-9999");
    $("#slcCliente").select2({placeholder: "Seleccione"});
    $("#slcTipos").select2({placeholder: "Seleccione"});


    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });


    $("#btn_consultar").click(function () {
        event.preventDefault();
        $("#excel").css("display", "none");
        $("#pdf").css("display", "none");

        var txtFechaIni = $("#txtFechaIni").val();
        var txtFechaFin = $("#txtFechaFin").val();
        var clientes    = ($("#slcCliente").val() != null) ? $("#slcCliente").val() :'';
        var tipos       = ($("#slcTipos").val() != null) ? $("#slcTipos").val() :''; 

        if ( txtFechaIni == "" || txtFechaFin == "") {
            crear_alerta('error', 'Rep. de Lavado de Dinero', 'Por favor ingrese el rango de fechas.');
            return false;
        }
        if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
            crear_alerta('error', 'Rep. de Lavado de Dinero', 'Verifique el período de fechas.');
            return false;
        }

        $("#h_fecha_ini").val(txtFechaIni);
        $("#h_fecha_fin").val(txtFechaFin);
        $("#h_tipo_pago").val(tipos);
        $("#h_clientes").val(clientes);

        $.ajax({
            dataType: 'text',
            type: 'POST',
            url: urlj+'modulo_cuentas_cobrar/reportes/lavado_dinero/1',
            data: {
                txtFechaIni:  txtFechaIni,
                txtFechaFin:  txtFechaFin,
                clientes:     clientes,
                tipos:        tipos,
                tipo_reporte: ""
            },
            beforeSend: function () {
                wait.start();
            },
            success:function(data) {
                $("#dv_contenedor").html(data);
                if(data.trim()!=''){
                    $("#excel").css("display", "");
                    $("#pdf").css("display", "");
                }
                wait.close();
            }
        });
    });


});
