jQuery(document).ready(function ($) {
    $('select').select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});

    $("#txtFecha_desde,#txtFecha_hasta").change(function(event) { validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta'); });

    $("#frmIngCatform").validate({
        ignore: "",
        rules: {
            txtFecha_desde: {required: true},
            txtFecha_hasta: {required: true}
            //slcTipoActivo: {required: true}
        },
        messages: {
            txtFecha_desde: "Campo requerido",
            txtFecha_hasta: "Campo requerido"
            //slcTipoActivo: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                console.log(error);
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }
            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");
        },
        submitHandler: function (form) {
            $("#contenedorTabla").hide("slide", { 
                direction: 'right'
            }, 400, function() { //despues de ocultar div enviar el ajax

                url_ajax = window.satelite.base_url('modulo_cuentas_cobrar/reportes/filtrar_ingreso_categoria');
                $.ajax({
                    url: url_ajax,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        slcCobrador: $("#slcCobrador").val(),
                        slcCategoria: $("#slcCategoria").val(),
                        txtFecha_desde: $("#txtFecha_desde").val(),
                        txtFecha_hasta: $("#txtFecha_hasta").val()
                    },
                    beforeSend: function () {
                        wait.start();
                    },
                    error: function (xhr, status, error){
                        exportarError(xhr.responseText);
                        wait.close();
                    },
                    success: function (json) {
                        $("#contenedorTabla").html(json.html);
                        $("#contenedorTabla").show("slide", {
                          direction: 'left'
                        }, 500);
                        wait.close();
                    }
                });
            });
        }
    });

    /*$("#slcTipoActivo").change(function(event) {
        cargar_grupos();
    });*/

    $("#slcCategoria").select2({
        placeholder:'Buscar productos',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'modulo_cuentas_cobrar/reportes/consultar_categoria',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
                return {
                   categoria: categoria
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.tia_id,
                        'text': (item.tia_codigo+' - '+item.tia_nombre)
                    });
                });
                return {
                    results: myResults
                };
            }
        }
   });
});
/*
function  cargar_grupos() {
    url_ajax = window.satelite.base_url('activo/reportes/filtrar_grupos_option');
    $.ajax({
        url: url_ajax,
        type: 'POST',
        dataType: 'json',
        data: {
            slcTipoActivo: $("#slcTipoActivo").val()
        },
        beforeSend: function () {
            wait.start('Cargando grupos...');
        },
        error: function (xhr, status, error){
            exportarError(xhr.responseText);
            wait.close();
        },
        success: function (json) {
            $("#slcGrupo").html(json.options);
            $("#slcGrupo").select2();
            wait.close();
        }
    });
}*/