$(document).ready(function () {

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $('select').select2();

    $("#txtcliente").select2({
        placeholder:'Buscar clientes',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'modulo_cuentas_cobrar/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cli_id,
                        'text': item.cli_codigo+" - "+item.nombre,
                    });
                });
                return {
                    results: myResults
                };
		    } 
        }
    });  

$("#txtvendedor").select2({
        placeholder:'Buscar Vendedor',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'modulo_cuentas_cobrar/procesos/get_vendedores_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (vendedor) {
                return {
                    vendedor: vendedor
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.ven_id,
                        'text': item.ven_codigo+" - "+item.ven_nombre+' '+item.ven_apellidos,
                    });
                });
                return {
                    results: myResults
                };
            } 
        }
    });  

    $("#txtcliente").change(function(){
        var cliente = $(this).val();
        if (cliente != "") {
            $.ajax({
                url: urlj + 'modulo_cuentas_cobrar/reportes/get_sucursal_cliente',
                type: 'POST',
                data: {
                    cliente:cliente
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $("#txtsucursal").html(data);
                    $('#txtsucursal').select2({placeholder: "Seleccione"});
                    wait.close();
                }
            });
        } else {
            $("#txtsucursal").html('<option value=""></option>');
            $('#txtsucursal').select2({placeholder: "Seleccione"});
        }
    });


    $("#btn_consultar").click(function () {
        event.preventDefault();
    
        var txtFechaIni     = $("#txtFechaIni").val();
        var txtFechaFin     = $("#txtFechaFin").val();

        var txtcliente      = ($("#txtcliente").val() > 0)?$("#txtcliente").val():'';
        var txtvendedor     = ($("#txtvendedor").val() > 0)?$("#txtvendedor").val():'';
        var txtsucursal     = ($("#txtsucursal").val() > 0)?$("#txtsucursal").val():'';
        var slc_estado      = ($("#slc_estado").val() > 0)?$("#slc_estado").val():'';

        var slc_tipo_pago   = ($("#slc_tipo_pago").val() > 0)?$("#slc_tipo_pago").val():'';
    
        var respuesta       = false;

        if ( txtFechaIni == "" || txtFechaFin == "") {
            crear_alerta('error', 'Reporte de estado de cuenta corriente cliente', 'Por favor ingrese el rango de fechas.');
            $("#txtFechaIni").val("");
            return false;
        } 

        if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
            crear_alerta('error', 'Reporte de estado de cuenta corriente cliente', 'Verifique el período de fechas.');
            return false;
        }

        $.ajax({
            url: window.gSateliteWhite.baseUrl('modulo_cuentas_cobrar/reportes/estado_cuenta_corriente_cliente'),
            data: {
                txtFechaIni: txtFechaIni,
                txtFechaFin: txtFechaFin,
                txtcliente:  txtcliente,
                txtvendedor: txtvendedor,
                txtsucursal: txtsucursal,
                slc_estado: slc_estado,
                slc_tipo_pago: slc_tipo_pago,
                tipo_reporte: ""    
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor_clientes").html(obj.html);
                $("#dv_contenedor_clientes").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            }
        });
    });

    $("#frm_reporte").validate({
        rules: {

        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var txtFechaIni         = $("#txtFechaIni").val();
            var txtFechaFin         = $("#txtFechaFin").val();

            var txtcliente          = ($("#txtcliente").val() > 0)?$("#txtcliente").val():'';
            var slc_estado          = ($("#slc_estado").val() > 0)?$("#slc_estado").val():'';
            var txtsucursal         = ($("#txtsucursal").val() > 0)?$("#txtsucursal").val():'';
        
            var respuesta = false;

            if ( txtFechaIni == "" || txtFechaFin == "") {
                crear_alerta('error', 'Reporte de estado de cuenta corriente cliente', 'Por favor ingrese el rango de fechas.');
                $("#txtFechaIni").val("");
                $("#slc_estado").val("");
                return false;
            } 

            if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
                crear_alerta('error', 'Reporte de estado de cuenta corriente cliente', 'Verifique el período de fechas.');
                return false;
            }
    
            form.submit();
        }
    });

    
    $("#txtsucursal").select2({//Datos de Campos #txtsucursal Creado 2019-2-18
        placeholder:'Buscar Sucursal',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'modulo_cuentas_cobrar/procesos/get_sucursal_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (sucursal) {
                return {
                    sucursal: sucursal
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.scl_id,
                        'text': item.scl_codigo+" - "+item.scl_nombre,
                    });
                });
                return {
                    results: myResults
                };
            } 
        }
    });  

});