$(document).ready(function(){

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });


    $("#btn_ejecutar").click(function () {
        event.preventDefault();
        $("#print_form").css("display", "none");

        var fecha_desde = $("#fecha_desde").val();
        var fecha_hasta = $("#fecha_hasta").val();
        var vacio = '<table class="responsive dynamicTable display table dataTable"><tr><th style="text-align: center;height: 40px;">NO SE ENCONTRARON REGISTROS</th></tr></table>';
    
        if (fecha_desde == "" || fecha_hasta == "") {
            crear_alerta('error', 'Atención', 'Por favor ingrese el rango de fechas.');
            return false;
        }
        if (!validarPeriodo(fecha_desde, fecha_hasta)) {
            crear_alerta('error', 'Atención', 'Verifique el período de fechas.');
            return false;
        }

        $.ajax({
            dataType: 'text',
            type: 'POST',
            url: urlj+'facturacion/facturar/descarga_masiva_inventario2/1',
            data: {
                fecha_desde:  fecha_desde,
                fecha_hasta:  fecha_hasta
            },
            beforeSend: function () {
                wait.start();
            },
            success:function(data) {
                $("#dv_contenedor").html(data);
                console.log(data);
                if(data.trim() != vacio){
                    $("#print_form").css("display", "");
                    $("#reporte").val(data);
                }
                wait.close();
            }
        });
    });


});
