$(document).ready(function(){

    $("select").select2({ placeholder: "Seleccione una opcion" });

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $("#chk_saldo").iButton({
        'labelOn':  ' Todos los Saldos ',
        'labelOff': '  Saldos Vigentes  ',
        change: function (element) {
            if (element.is(':checked')) {
                $("#hdn_chk_saldo").val(1);
            } else {
                $("#hdn_chk_saldo").val(0);
            }
        }
    });

    $("#slc_cliente").select2({
        placeholder: 'Buscar cliente',
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_cuentas_cobrar/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cli_id,
                        'text': item.cli_codigo + " - " + item.nombre,
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({ id: valor, text: texto });
                $("#" + idElemento).select2('disable');
            }
        }
    });


    $("#btn_consultar").click(function () {
        event.preventDefault();
        $("#excel").css("display", "none");
        $("#pdf").css("display", "none");
        var ver_saldo   = $("#hdn_chk_saldo").val();
        var fecha_hasta = $("#txt_fecha_hasta").val();
        var vendedor    = ($("#slc_vendedor").val() != null) ? $("#slc_vendedor").val() :''; 
        var cliente     = ($("#slc_cliente").val() != null) ? $("#slc_cliente").val() :'';
        var sucursal    = ($("#slc_sucursal").val() != null) ? $("#slc_sucursal").val() : '';
        var vacio = '<table class="responsive dynamicTable display table dataTable" border="1"><tr><th style="text-align: center;">No se encontraron registros</th></tr></table>';
        if ( fecha_hasta == "") {
            crear_alerta('error', 'Atención', 'Debe especificar una fecha.');
            return false;
        }

        $("#h_fecha_hasta").val(fecha_hasta);
        $("#h_vendedor").val(vendedor);
        $("#h_cliente").val(cliente);
        $("#h_sucursal").val(sucursal);
        $("#h_ver_saldo").val(ver_saldo);

        $.ajax({
            dataType: 'text',
            type: 'POST',
            url: urlj+'modulo_cuentas_cobrar/reportes/composicion_saldos/1',
            data: {
                fecha_hasta:  fecha_hasta,
                vendedor:     vendedor,
                cliente:      cliente,
                sucursal:     sucursal,
                ver_saldo:    ver_saldo,
                tipo_reporte: ""
            },
            beforeSend: function () {
                wait.start();
            },
            success:function(data) {
                $("#dv_contenedor").html(data);
                if(data.trim() != vacio){
                    $("#excel").css("display", "");
                    $("#pdf").css("display", "");
                }
                wait.close();
            }
        });
    });


});
