$(document).ready(function(){

    $("select").select2();

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $("#chk_tipo").iButton({
        'labelOn':  '  Vendedores  ',
        'labelOff': '  Cobradores  ',
        change: function (element) {
            if (element.is(':checked')) {
                $("#slc_cobrador").val('').trigger('change');
                $("#slc_cobrador").select2();
                $("#div_cobra").hide();
                $("#div_vende").show();
            } else {
                $("#slc_vendedor").val('').trigger('change');
                $("#slc_vendedor").select2();
                $("#div_vende").hide();
                $("#div_cobra").show();
            }
        }
    });

    $("body").on("change", "#txt_fecha_desde, #txt_fecha_hasta", function(){
        if ($("#txt_fecha_desde").val() != "" && $("#txt_fecha_hasta").val() != "") {
            verifica_fecha($('#txt_fecha_desde').val(), $('#txt_fecha_hasta').val());
        }
    });

    $("#btn_consultar").click(function () {
        event.preventDefault();
        $(".print").hide();
        var fecha_desde = $("#txt_fecha_desde").val();
        var fecha_hasta = $("#txt_fecha_hasta").val();
        var vendedor = ($("#slc_vendedor").val() > 0) ? $("#slc_vendedor").val() : 0; 
        var cobrador = ($("#slc_cobrador").val() > 0) ? $("#slc_cobrador").val() : 0;
        var category = ($("#slc_category").val() > 0) ? $("#slc_category").val() : 0;
        if (verifica_fecha(fecha_desde, fecha_hasta)) {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_cuentas_cobrar/reportes/cobranza_comision/1',
                data: {
                    fecha_desde: fecha_desde,
                    fecha_hasta: fecha_hasta,
                    vendedor: vendedor,
                    cobrador: cobrador,
                    category: category,
                    tipo_reporte: ""
                },
                beforeSend: function () {
                    wait.start();
                },
                success:function(data) {
                    $("#dv_contenedor").html(data.tabla);
                    if(data.filas > 0){
                        $("#fecha_desde").val(fecha_desde);
                        $("#fecha_hasta").val(fecha_hasta);
                        $("#vendedor").val(vendedor);
                        $("#cobrador").val(cobrador);
                        $("#category").val(category);
                        $(".print").show();
                    }
                    wait.close();
                }
            });
        }
    });

});

function verifica_fecha(fecha_ini, fecha_fin){
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if(Date.parse(fecha_i) > Date.parse(fecha_f)){
        crear_alerta('error', 'Atención', 'Verifique las fechas del período');
        return false;
    } else {
        return true;
    }
}

