jQuery(document).ready(function ($) {
    $('select').select2();

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            //slcTipoCliente: {required: true, min:1}
        },
        messages: {
            //slcTipoCliente: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select')){
                $(element).next().append(error);
            } else {
                error.insertAfter(element);
            }
        },
        submitHandler: function (form) {
            var fecha_desde = $("#txt_desde").val();
            var fecha_hasta = $("#txt_hasta").val();
            if ( fecha_desde != "" || fecha_hasta != "") {                
                // if ( fecha_desde == "") {
                //     crear_alerta('error','Alerta','Verifique fecha desde.');
                //     return false;
                // }
                if ( fecha_hasta == "") {
                    crear_alerta('error','Alerta','Verifique fecha hasta.');
                    return false;
                }
                // if(!validarPeriodo(fecha_desde,fecha_hasta)){
                //     crear_alerta('error','Alerta','Verifique el período de fechas.');
                //     return false;
                // }
            }                  
            $("#contenedorTabla").hide("slide", { 
                direction: 'right'
                }, 400, function() { //despues de ocultar div enviar el ajax    
                    url_ajax = window.satelite.base_url('modulo_cuentas_cobrar/reportes/filtrar_antiguedad_saldo');
                    $.ajax({
                        url: url_ajax,
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            slcTipoCliente: $("#slcTipoCliente").val(),
                            slcVendedor: $("#slcVendedor").val(),
                            slcCliente: $("#slcCliente").val(),
                            slcSucursal: $("#slcSucursal").val(),
                            slc_proyecto: $("#slc_proyecto").val(),
                            slc_dias: $("#slc_dias").val(),
                            txt_desde: $("#txt_desde").val(),
                            txt_hasta: $("#txt_hasta").val()
                        },
                        beforeSend: function () {
                            wait.start();
                        },
                        error: function (xhr, status, error){
                        exportarError(xhr.responseText);
                        wait.close();
                    },
                    success: function (json) {
                        $("#contenedorTabla").html(json.html);
                        $("#contenedorTabla").show("slide", {
                            direction: 'left'
                        }, 500);
                        wait.close();
    
                    }
                });
            });
           
       }
   });

    $("#slcCliente").change(function(){
        get_sucursales_cliente($(this).val());
        if ( $(this).val() != ""){
            var cliente = $(this).val();
            $.ajax({
                url: urlj + 'modulo_cuentas_cobrar/reportes/get_proyectos_cliente',
                type: 'POST',
                dataType: 'text',
                data: {cliente:cliente},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $("#slc_proyecto").html(data);
                    $('#slc_proyecto').select2({placeholder: "Seleccione"});
                    wait.close();
                }
            });
        } else {
            $("#slc_proyecto").html('<option value=""></option>');
            $('#slc_proyecto').select2({placeholder: "Seleccione"});
        }
   });

});

function get_sucursales_cliente(cliente) {
    if (cliente != "") {
        $.ajax({
            url: urlj + 'modulo_cuentas_cobrar/reportes/get_sucursal_cliente',
            type: 'POST',
            data: {
                cliente:cliente
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#slcSucursal").html(data);
                $('#slcSucursal').select2({placeholder: "Seleccione"});
                wait.close();
            }
        });
    } else {
        $("#slcSucursal").html('<option value=""></option>');
        $('#slcSucursal').select2({placeholder: "Seleccione"});
    }
}
