jQuery(document).ready(function ($) {
    $('#tabla').dataTable();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});

    $("#txtFecha_desde,#txtFecha_hasta").change(function(event) {  validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta'); });

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            txtFecha_desde: {required: true},
            txtFecha_hasta: {required: true}
        },
        messages: {
            txtFecha_desde: "Campo requerido",
            txtFecha_hasta: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }
            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");
        },
        submitHandler: function (form) {
            wait.start();
            $("#contenedorTabla").hide("slide", { 
                direction: 'right'
            }, 400, function() { //despues de ocultar div enviar el ajax
                var otra_url_mod = "";
                var otro_modulo = $("#otro_modulo").val();
                url_ajax = urlj + 'modulo_cuentas_cobrar/procesos/filtrar_pagos';
                if (otro_modulo > 0) {
                    otra_url_mod = $("#url_otro_mod").val();
                    url_ajax += "/1";
                }
                $.ajax({
                    type: 'POST',
                    url: url_ajax,
                    dataType: 'json',
                    data: {
                        txt_otra_url: otra_url_mod,
                        txtFecha_desde: $("#txtFecha_desde").val(),
                        txtFecha_hasta: $("#txtFecha_hasta").val(),
                        txt_abc_anl:  $("#txt_abn_anl").val()
                    },
                    beforeSend: function () {
                        wait.start();
                    },
                    error: function (xhr, status, error){
                        exportarError(xhr.responseText);
                        wait.close();
                    },
                    success: function (json) {
                        $("#contenedorTabla").html(json.html);
                        $('#tabla').dataTable({
                            "aaSorting": [[ 1, "asc" ]]
                        });
                        $("#contenedorTabla").show("slide", {
                            direction: 'left'
                        }, 500);
                        wait.close();
                    }
                });
            });
        }
    });

    $("#chk_abn_anl").iButton({
        'labelOn': 'Anticipos',
        'labelOff': ' Abonos ',
        'resizeHandle': false,
        // 'resizeContainer': false,
        change: function (element) {
            if (element.is(':checked')) {
                $("#txt_abn_anl").val(1);
            } else {
                $("#txt_abn_anl").val(0);
            }
        }
    });

    $('#contenedorTabla').on('click', '.anular_abono', function (){
        event.preventDefault();
        /* Act on the event */
        id_abono = $(this).attr('id_abono');
        url_ajax = window.satelite.base_url('modulo_cuentas_cobrar/procesos/anular_pago_abono');
        $.ajax({
           url: url_ajax,
           type: 'POST',
           dataType: 'json',
           data: {
                id_abono: id_abono
            },
            beforeSend: function () {
                wait.start();
            },
            error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                wait.close();
                $.fancybox(json.html);
            }
        });
    });

    $('body').on('click', '#btnAceptar', function(event) {
        event.preventDefault();
        /* Act on the event */
        motivo = $("#txtMotivo").val().trim();
        if (motivo == '') {
            crear_alerta('error','Error','Favor escribir el motivo de anulación.');
        } else {
            id_abono = $("#id_abono_anular").val();
            url_ajax = window.satelite.base_url('modulo_cuentas_cobrar/procesos/anular_pago_abono');
            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    id_abono: id_abono,
                    motivo_anulacion: motivo
                },
                beforeSend: function () {
                    wait.start();
                },
                error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    wait.close();
                    if(json.exito == 1) {
                        crear_alerta('success','Éxito','Anulación realizada con éxito');
                        $('#btnConsultar').trigger('click');
                        $.fancybox.close();
                    } else {
                        $.fancybox.close();
                        crear_alerta('error','Error','Favor escribir el motivo de anulación.');
                    }
                }
            });
        }
    });

}); //END ready()



function redireccionar() {
    $.ajax({
        url:window.satelite.base_url('modulo_cuentas_cobrar/procesos/redireccionar'),
        type: 'POST',
        dataType: 'json',
        data: {
            url: $('#agregar_pago').attr('url'),
            modulo: $('#agregar_pago').attr('modulo')
        },
        beforeSend: function () {
            //wait.start();
        },
        error: function (xhr, status, error){
            exportarError(xhr.responseText);
            wait.close();
        },
        success: function (json) {
            //alert(json.ir);
            window.location.href = json.ir;
        }
    });    
}
