$(document).ready(function($) {

    $('#slcEstado').select2({placeholder: 'Seleccione'});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior"
    });

    $("#slcCliente").select2({
        placeholder:'Buscar clientes',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'modulo_cuentas_cobrar/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cli_id,
                        'text': item.cli_codigo+" - "+item.nombre,
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
                $("#" + idElemento).select2('disable');
            }
        }
    });

    $("body").on("change", "#txtFecha_desde, #txtFecha_hasta", function(){
        if (!(verifica_fecha($('#txtFecha_desde').val(), $('#txtFecha_hasta').val()))) {
            $('#txtFecha_desde').val('');
        }
    });

    $('#btnConsultar').click(function(e) {
        var fec_ini = $('#txtFecha_desde').val();
        var fec_fin = $('#txtFecha_hasta').val();
        if (fec_ini != "" && fec_fin != "") {
            var estado = $('#slcEstado').val();
            var cliente = $('#slcCliente').val();
            $.ajax({
                type: 'POST',
                url: urlj + 'modulo_cuentas_cobrar/procesos/buscar_anticipos_cliente',
                data: {
                    fec_ini: fec_ini,
                    fec_fin: fec_fin,
                    estado: estado,
                    cliente: cliente
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function(data){
                    $("#contenedorTabla").html(data);
                    $('#tabla').dataTable({
                        "aaSorting": [[ 1, "asc" ]]
                    });
                    wait.close();
                }
            });
        } else {
            crear_alerta('error','Fechas','Fechas del período son requeridas.');    
            return false;
        }
    });

    $('#contenedorTabla').on('click', '.anular_anticipo', function (){
        event.preventDefault();
        id_anl = $(this).data('id');
        console.log(id_anl);
        url_ajax = window.satelite.base_url('modulo_cuentas_cobrar/procesos/anular_pago_anticipo');
        $.ajax({
           url: url_ajax,
           type: 'POST',
           dataType: 'json',
           data: {
                id_anl: id_anl
            },
            beforeSend: function () {
                wait.start();
            },
            error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                wait.close();
                $.fancybox(json.html);
            }
        });
    });

    $('body').on('click', '#btnAceptar', function(event) {
        event.preventDefault();
        motivo = $("#txtMotivo").val().trim();
        if (motivo == '') {
            crear_alerta('error','Error','Favor escribir el motivo de anulación.');
        } else {
            id_abono = $("#id_anl_anular").val();
            id_prc = $("#id_prc").val();
            url_ajax = window.satelite.base_url('modulo_cuentas_cobrar/procesos/anular_pago_anticipo');
            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    id_anl: id_abono,
                    id_prc: id_prc,
                    motivo_anulacion: motivo
                },
                beforeSend: function () {
                    wait.start();
                },
                error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    // wait.close();
                    if(json.exito == 1) {
                        crear_alerta('success','Éxito','Anulación realizada con éxito');
                        $('#btnConsultar').trigger('click');
                        $.fancybox.close();
                    } else {
                        crear_alerta('error','Error','Favor verifique la información.');
                        $.fancybox.close();
                    }
                }
            });
        }
    });

}); //end document).ready

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error','Fechas','Verifique las fechas del período');
        return false;
    }else{
        return true;
    }
}