$(document).ready(function () {
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $("#frm-reporte").validate({
        rules: {
           
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error', 'Campos necesarios', 'Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form) {


            var fecha_desde = $("#filtro_desde").val();
            var fecha_hasta = $("#filtro_hasta").val();

            if ( fecha_desde != "" || fecha_hasta != "") {

                if ( fecha_desde == "") {
                    crear_alerta('error','Alerta','Verifique fecha desde.');
                    return false;
                }

                if ( fecha_hasta == "") {
                    crear_alerta('error','Alerta','Verifique fecha hasta.');
                    return false;
                }

                if(!verifica_fecha(fecha_desde,fecha_hasta)){
                    crear_alerta('error','Alerta','Verifique el periodo de fechas.');
                    return false;
                }

            }
            
            form.submit();
        }
    });

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });


    /*Busqueda*/
    $("#btnConsultar").click(function () {

        var fecha_desde = $("#txt_desde").val();
        var fecha_hasta = $("#txt_hasta").val();

        var servicio    = $("#slc_servicio").val();

        if ( fecha_desde != "" || fecha_hasta != "") {

            if ( fecha_desde == "") {
                crear_alerta('error','Alerta','Verifique fecha desde.');
                return false;
            }

            if ( fecha_hasta == "") {
                crear_alerta('error','Alerta','Verifique fecha hasta.');
                return false;
            }

            if(!verifica_fecha(fecha_desde,fecha_hasta)){
                crear_alerta('error','Alerta','Verifique el periodo de fechas.');
                return false;
            }

        }
     
        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('modulo_contratos/reportes/filtrar_servicios_inactivos_clientes/1'),
                        data: {fecha_desde:fecha_desde,fecha_hasta:fecha_hasta,servicio:servicio},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                            $(".print").show();

                            $("#filtro_desde").val(fecha_desde);
                            $("#filtro_hasta").val(fecha_hasta);

                            $("#filtro_servicio").val(servicio);

                            var oTable = $('#tblListado').dataTable();
                            oTable.fnDestroy();

                            $("#tbContenedorListado").html(result);
                            aplicarDataTable('tblListado');

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);
                        }
                    });
                }
        );
    });
});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}