$(document).ready(function () {

    $('select').select2({placeholder: 'Seleccione una opción'});

    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    
    $(".txt_periodo").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'mm-yy',
        monthNamesShort: ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#txt_periodo_fecha").change(function (){
        if ($(this).val() != ""){
            var fecha       = $(this).val();
            fecha           = "01-"+fecha;
        
            var fecha_array     = fecha.split('-');

            var date            = new Date(fecha_array[1]+"-"+fecha_array[0]+"-"+fecha_array[2]);
            var ultimoDia       = new Date(date.getFullYear(), date.getMonth() + 1, 0);
            var mes     = ultimoDia.getMonth() + 1;
            var year    = ultimoDia.getFullYear();   

            var meses   = ["Enero", "Febreo", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];

            $("#txt_periodo").val(meses[ultimoDia.getMonth()] + "-" + year);      
        } else{
            $("#txt_periodo").val("");
        }
    });

    $("#slcServicio").change(function () {
        var servicio = $(this).val();
        if (servicio > 0) {

            $.ajax({
                url: window.gSateliteWhite.baseUrl('modulo_contratos/procesos/get_planes_servicio'),
                data: {servicio: servicio},
                type: "post",
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    $("#slcPlanes").html(result);
                    $("#slcPlanes").select2({placeholder: "Seleccione una opción"});
                }
            });
        } else {
            $("#slcPlanes").html('');
            $("#slcPlanes").select2({placeholder: "Seleccione una opción"});
        }
    });


    $("#btn_consultar").click(function () {
        event.preventDefault();
        var fechaInicio_corte   = $("#txt_fecha_corte_inicio").val();
        var fechaFin_corte      = $("#txt_fecha_corte_fin").val();

        var fechaInicio         = $("#txtFechaInicio").val();
        var fechaFin            = $("#txtFechaFin").val();

        var slcServicio         = ($("#slcServicio").val() > 0)?$("#slcServicio").val():'';
        var slcPlanes           = ($("#slcPlanes").val() > 0)?$("#slcServicio").val():'';
        var slcTipoFactura      = ($("#slcTipoFactura").val() > 0)?$("#slcTipoFactura").val():'';

        var periodo             = $("#txt_periodo").val();
        var respuesta = false;

        //if ( slcTipoFactura == "" ) {
          //  crear_alerta('error', 'Aviso', 'Seleccione el tipo de factura.');
            //return false;
        //}

        //if ( fechaInicio  == "" && fechaFin == "" && fechaInicio_corte == "" && fechaFin_corte == "" && slcServicio == "" && slcPlanes == "" && slcTipoFactura == "" ) {
          //  crear_alerta('error', 'Aviso', 'Favor ingrese al menos un campo.');
          // return false;
        //}

        if ( periodo  == "" ) {
          crear_alerta('error', 'Aviso', 'Favor ingrese el período a buscar.');
          return false;
        }

        if (fechaInicio_corte != '') {
            
            if ( fechaFin_corte == '') {
                crear_alerta('error', 'Aviso', 'Favor ingrese fecha fin de fecha corte');
                return false;
            }


            if ( fechaInicio != "" || fechaFin != "") {
                crear_alerta('error', 'Aviso', 'La búsqueda debe ser solo por fecha corte o fecha de facturación');
                $("#txtFechaInicio").val("");
                $("#txtFechaFin").val("");
                return false;
            } 

            respuesta = validar_fechas(fechaInicio_corte,fechaFin_corte,"corte");

            if ( respuesta == false ) {
                return false;
            }


        }

        if (fechaFin_corte != '') {

            if ( fechaInicio_corte == '') {
                crear_alerta('error', 'Aviso', 'Favor ingrese fecha inicio de corte');
                return false;
            }

            if ( fechaInicio != "" || fechaFin != "") {
                crear_alerta('error', 'Aviso', 'La búsqueda debe ser solo por fecha Corte o fecha de facturación');
                $("#txtFechaInicio").val("");
                $("#txtFechaFin").val("");
                return false;
            } 

            respuesta = validar_fechas(fechaInicio_corte,fechaFin_corte,"corte");

            if ( respuesta == false ) {
                return false;
            }


        }

      
        if (fechaInicio != '') {

            if ( fechaFin == '') {
                crear_alerta('error', 'Aviso', 'Favor ingrese fecha fin de facturación');
                return false;
            }

            if ( fechaInicio_corte != "" || fechaFin_corte != "") {
                crear_alerta('error', 'Aviso', 'La búsqueda debe ser solo por fecha Corte o fecha de facturación');
                $("#txt_fecha_corte_inicio").val("");
                $("#txt_fecha_corte_fin").val("");
                return false;
            } 

            respuesta = validar_fechas(fechaInicio,fechaFin,"facturación");

            if ( respuesta == false ) {
                return false;
            }

        }


        if (fechaFin != '') {

            if ( fechaInicio == '') {
                crear_alerta('error', 'Aviso', 'Favor ingrese fecha inicial de facturación');
                return false;
            }

            if ( fechaInicio_corte != "" || fechaFin_corte != "") {
                crear_alerta('error', 'Aviso', 'La búsqueda debe ser solo por fecha Corte o fecha de facturación');
                $("#txt_fecha_corte_inicio").val("");
                $("#txt_fecha_corte_fin").val("");
                return false;
            } 

            respuesta = validar_fechas(fechaInicio,fechaFin,"facturación");

            if ( respuesta == false ) {
                return false;
            }

        }

        $.ajax({
            url: window.gSateliteWhite.baseUrl('modulo_contratos/procesos/reimpresion_facturas'),
            data: {
                fecha_inicio: fechaInicio,
                fecha_fin:fechaFin,
                servicio:slcServicio,
                plan:slcPlanes,
                tipo_factura:slcTipoFactura,
                fecha_inicio_corte: fechaInicio_corte, 
                fecha_fin_corte: fechaFin_corte,
                periodo:periodo,
                tipo_reporte: ""    
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor_clientes").html(obj.html);
                $("#dv_contenedor_clientes").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            }
        });
    });

    function validar_fechas(fecha_ini, fecha_fin, mensaje){
        var result = true;

        if ( fecha_ini == '' ) {
            crear_alerta('error', 'Aviso', 'Favor ingrese una fecha de '+mensaje+' inicial.');
            result = false;
        }

        if ( fecha_fin == '' ) {
            crear_alerta('error', 'Aviso', 'Favor ingrese una fecha de '+mensaje+' final.');
            result = false;
        }


        if (!validarPeriodo(fecha_ini, fecha_fin)) {
            crear_alerta('info', 'Aviso', 'Verifique el período seleccionado.');
            result = false;
        }

        return result;
    }

    $("#frm_reporte").validate({
        rules: {

        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var periodo = $("#txt_periodo").val();
          
            if ( periodo  == "" ) {
              crear_alerta('error', 'Aviso', 'Favor ingrese el período a buscar.');
              return false;
            }
    
            form.submit();
        }
    });

    $("a").click(function() {//Requisiciones despachadas
        $(".linker2").fancybox({
                'width'  : 900,           // set the width
                'height' : 500,           // set the height
                'onStart': function() { $("#divform2").css("display","block"); },            
                'onClosed': function() { $("#divform2").css("display","none"); }
        });
    }); 

    //Inicializador de fancy box
    $(function(){
        $(".linker2").fancybox({
                'width'  : 900,           // set the width
                'height' : 500,           // set the height
                'onStart': function() { $("#divform2").css("display","block"); },            
                'onClosed': function() { $("#divform2").css("display","none"); }
        });
    });


});

function clicker2(id2) {
    var contenido='';
    var jqXHR = $.ajax({
                  dataType    : 'json',
                  type        : "POST",
                  cache       : false,
                  url         : window.gSateliteWhite.baseUrl('facturacion/consultas/anular_factura'),
                  data        : {factura:id2},
                  success     : function(data) {
                      $("#divform2").empty();
                      $("#divform2").append(data.resultado);
                      mostrar_fancy_box(); 
                      $('#boton_anular').hide();
                      $('#anular_form').hide();
                }
                }).done(function() { 
                      $("#divform2").append(contenido);
                }).fail(function(jqXHR, textStatus){

                });; 
}

function mostrar_fancy_box(valor){
    $.fancybox( $("#divform2"+valor).html(), {
            'width'  : 900,           // set the width
            'height' : 500,           // set the height
            'onStart': function() { $("#divform2"+valor).css("display","block"); },            
            'onClosed': function() { $("#divform2"+valor).css("display","none"); }
    });    
}